/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks.entities;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlockEntities;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.datapacks.ScalableReward;

public class AncientPotBlockEntity
extends BlockEntity {
    private int lootQuality = 1;

    public AncientPotBlockEntity(BlockPos pos, BlockState state) {
        super(WetlandWhimsyBlockEntities.ANCIENT_POT.get(), pos, state);
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("loot_quality", this.lootQuality);
    }

    protected void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.lootQuality = tag.getInt("loot_quality");
    }

    public void increaseLootQuality() {
        ++this.lootQuality;
    }

    public int lootQuality() {
        return this.lootQuality;
    }

    public void dropLoot(ServerLevel level, BlockPos pos) {
        if (this.lootQuality < 1) {
            WetlandWhimsy.LOGGER.warn("lootQuality is " + this.lootQuality + "... increasing to 1");
            this.lootQuality = 1;
        }
        List<ItemStack> loot = ScalableReward.Manager.getLoot(level, (ItemLike)WetlandWhimsyItems.ANCIENT_COIN.get(), this.lootQuality);
        for (ItemStack item : loot) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)item);
        }
    }
}

