/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks.entities;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import uwu.juni.wetland_whimsy.client.particles.coloredfire.ColoredFireParticleOptions;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.blocks.AncientBrazierBlock;
import uwu.juni.wetland_whimsy.content.blocks.entities.AncientBrazierBlockEntity;
import uwu.juni.wetland_whimsy.datagen.loot.WetlandWhimsyMiscLoot;
import uwu.juni.wetland_whimsy.datapacks.Incense;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

@ParametersAreNonnullByDefault
public class AncientBrazierSpawner
extends BaseSpawner {
    private int spawnedEntityCount = 0;
    private SimpleWeightedRandomList<ResourceKey<LootTable>> lootTablesToEject = new SimpleWeightedRandomList.Builder().add(WetlandWhimsyMiscLoot.INTERMEDIATE_LOOT, 1).add(WetlandWhimsyMiscLoot.EPIC_LOOT, 1).add(WetlandWhimsyMiscLoot.ANCIENT_COIN, 2).build();

    public void broadcastEvent(Level level, BlockPos pos, int id) {
        level.blockEvent(pos, (Block)WetlandWhimsyBlocks.ANCIENT_BRAZIER.get(), id, 0);
    }

    public void setNextSpawnData(@Nullable Level level, BlockPos pos, SpawnData data) {
        super.setNextSpawnData(level, pos, data);
        if (level != null) {
            BlockState blockstate = level.getBlockState(pos);
            level.sendBlockUpdated(pos, blockstate, blockstate, 4);
        }
    }

    public void serverTick(ServerLevel serverLevel, BlockPos pos) {
        Optional uuid;
        if (!((AncientBrazierBlock.Flame)((Object)serverLevel.getBlockState(pos).getValue(AncientBrazierBlock.FLAME))).equals((Object)AncientBrazierBlock.Flame.LIT)) {
            return;
        }
        RandomSource random = serverLevel.getRandom();
        if (this.spawnDelay > 3) {
            this.spawnDelay -= 3;
        } else if (this.spawnDelay > 0) {
            --this.spawnDelay;
        }
        if (this.spawnDelay == 1) {
            ++this.spawnedEntityCount;
            BlockEntity entity = serverLevel.getBlockEntity(pos);
            if (entity != null) {
                entity.setChanged();
            }
            this.setRandomEntity(serverLevel, pos);
        }
        Optional<Object> optional = uuid = this.spawnDelay <= 0 ? this.spawnMob(serverLevel, pos) : Optional.empty();
        if (uuid.isPresent()) {
            this.spawnDelay = random.nextInt(200, 400);
            for (int i = 0; i < random.nextInt(2, 4); ++i) {
                this.spawnMob(serverLevel, pos);
            }
        }
        if (this.spawnedEntityCount >= 8) {
            this.spawnedEntityCount = 0;
            serverLevel.setBlock(pos, (BlockState)serverLevel.getBlockState(pos).setValue(AncientBrazierBlock.FLAME, (Comparable)((Object)AncientBrazierBlock.Flame.SMOLDERING)), 2);
            this.ejectLoot(serverLevel, pos, random);
            BlockEntity be = serverLevel.getBlockEntity(pos);
            if (be instanceof AncientBrazierBlockEntity) {
                AncientBrazierBlockEntity ab = (AncientBrazierBlockEntity)be;
                ab.killIncense();
            }
            return;
        }
    }

    public void setRandomEntity(ServerLevel level, BlockPos pos) {
        AncientBrazierBlockEntity ab2;
        BlockEntity be = level.getBlockEntity(pos);
        RandomSource random = level.getRandom();
        Function<AncientBrazierBlockEntity, EntityType> getEntity = ab -> {
            List<ResourceLocation> entities = ab.getIncense(level).entities();
            ResourceLocation rloc = entities.get(random.nextInt(0, entities.size()));
            return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(rloc);
        };
        EntityType entity = be instanceof AncientBrazierBlockEntity && (ab2 = (AncientBrazierBlockEntity)be).hasIncense() ? getEntity.apply(ab2) : (EntityType)((Holder)level.registryAccess().lookupOrThrow(Registries.ENTITY_TYPE).getOrThrow(WetlandWhimsyTags.Entities.SPAWNS_FROM_ANCIENT_BRAZIER).getRandomElement(random).get()).value();
        this.setEntityId(entity, (Level)level, random, pos);
    }

    public Optional<UUID> spawnMob(ServerLevel level, BlockPos pos) {
        SpawnData.CustomSpawnRules spawndata$customspawnrules;
        double d2;
        RandomSource randomsource = level.getRandom();
        SpawnData spawndata = this.getOrCreateNextSpawnData((Level)level, level.getRandom(), pos);
        CompoundTag compoundtag = spawndata.entityToSpawn();
        ListTag listtag = compoundtag.getList("Pos", 6);
        Optional optional = EntityType.by((CompoundTag)compoundtag);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        int i = listtag.size();
        double d0 = i >= 1 ? listtag.getDouble(0) : (double)pos.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * 7.0 + 0.5;
        double d1 = i >= 2 ? listtag.getDouble(1) : (double)(pos.getY() + randomsource.nextInt(3) - 1);
        double d = d2 = i >= 3 ? listtag.getDouble(2) : (double)pos.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * 7.0 + 0.5;
        if (!level.noCollision(((EntityType)optional.get()).getSpawnAABB(d0, d1, d2))) {
            return Optional.empty();
        }
        Vec3 vec3 = new Vec3(d0, d1, d2);
        if (!AncientBrazierSpawner.inLineOfSight((Level)level, pos.getCenter(), vec3)) {
            return Optional.empty();
        }
        BlockPos blockpos = BlockPos.containing((Position)vec3);
        if (!SpawnPlacements.checkSpawnRules((EntityType)((EntityType)optional.get()), (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.TRIAL_SPAWNER, (BlockPos)blockpos, (RandomSource)level.getRandom())) {
            return Optional.empty();
        }
        if (spawndata.getCustomSpawnRules().isPresent() && !(spawndata$customspawnrules = (SpawnData.CustomSpawnRules)spawndata.getCustomSpawnRules().get()).isValidPosition(blockpos, level)) {
            return Optional.empty();
        }
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)compoundtag, (Level)level, e -> {
            e.moveTo(d0, d1, d2, randomsource.nextFloat() * 360.0f, 0.0f);
            return e;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!mob.checkSpawnObstruction((LevelReader)level)) {
                return Optional.empty();
            }
            boolean flag = spawndata.getEntityToSpawn().size() == 1 && spawndata.getEntityToSpawn().contains("id", 8);
            EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(mob.blockPosition()), (MobSpawnType)MobSpawnType.TRIAL_SPAWNER, (SpawnGroupData)new SpawnGroupData(this){}, (IOwnedSpawner)this, (boolean)flag);
            mob.setPersistenceRequired();
            spawndata.getEquipment().ifPresent(arg_0 -> ((Mob)mob).equip(arg_0));
        }
        if (!level.tryAddFreshEntityWithPassengers(entity)) {
            return Optional.empty();
        }
        this.effects(pos, blockpos, level);
        level.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, blockpos);
        return Optional.of(entity.getUUID());
    }

    private void effects(BlockPos pos, BlockPos mobSpawnPos, ServerLevel level) {
        AncientBrazierBlockEntity ab = (AncientBrazierBlockEntity)level.getBlockEntity(pos);
        RandomSource random = level.getRandom();
        BiConsumer<BlockPos, Incense> spawnParticles = (blockpos, incense) -> {
            for (int i = 0; i < random.nextInt(8, 10); ++i) {
                level.sendParticles((ParticleOptions)new ColoredFireParticleOptions(incense.color(), (float)random.nextInt(18, 24) / 10.0f), (double)((float)blockpos.getX() + (float)random.nextInt(-2, 12) / 10.0f), (double)((float)blockpos.getY() + (float)random.nextInt(-2, 12) / 10.0f), (double)((float)blockpos.getZ() + (float)random.nextInt(-2, 12) / 10.0f), 1, 0.0, 0.0, 0.0, 0.0);
            }
        };
        if (ab != null && ab.hasIncense()) {
            Incense incense2 = ab.getIncense(level);
            spawnParticles.accept(pos, incense2);
            spawnParticles.accept(mobSpawnPos, incense2);
            level.playSound(null, mobSpawnPos, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.BLOCKS);
        } else {
            level.levelEvent(3011, pos, 1);
            level.levelEvent(3012, mobSpawnPos, 1);
        }
    }

    private static boolean inLineOfSight(Level level, Vec3 spawnerPos, Vec3 mobPos) {
        BlockHitResult blockhitresult = level.clip(new ClipContext(mobPos, spawnerPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return blockhitresult.getBlockPos().equals((Object)BlockPos.containing((Position)spawnerPos)) || blockhitresult.getType() == HitResult.Type.MISS;
    }

    private void ejectLoot(ServerLevel level, BlockPos pos, RandomSource random) {
        LootParams params;
        AncientBrazierBlockEntity ab;
        Optional x = this.lootTablesToEject.getRandom(random);
        if (x.isEmpty()) {
            return;
        }
        BlockEntity be = level.getBlockEntity(pos);
        LootTable table = level.getServer().reloadableRegistries().getLootTable((ResourceKey)(be != null && be instanceof AncientBrazierBlockEntity && (ab = (AncientBrazierBlockEntity)be).hasIncense() ? ab.getIncense(level).getLootKey() : (ResourceKey<LootTable>)((WeightedEntry.Wrapper)x.get()).data()));
        ObjectArrayList loot = table.getRandomItems(params = new LootParams.Builder(level).create(LootContextParamSets.EMPTY));
        if (loot.isEmpty()) {
            return;
        }
        for (ItemStack itemstack : loot) {
            DefaultDispenseItemBehavior.spawnItem((Level)level, (ItemStack)itemstack, (int)2, (Direction)Direction.UP, (Position)Vec3.atBottomCenterOf((Vec3i)pos).relative(Direction.UP, 1.2));
        }
        level.levelEvent(3014, pos, 0);
    }

    public CompoundTag save(@Nonnull CompoundTag tag) {
        tag.putShort("SpawnedEntityCount", (short)this.spawnedEntityCount);
        return super.save(tag);
    }

    public void load(@Nullable Level level, @Nonnull BlockPos pos, @Nonnull CompoundTag tag) {
        this.spawnedEntityCount = tag.getInt("SpawnedEntityCount");
        super.load(level, pos, tag);
    }
}

