/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks.entities;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlockEntities;
import uwu.juni.wetland_whimsy.content.blocks.entities.AncientBrazierSpawner;
import uwu.juni.wetland_whimsy.datapacks.Datapacks;
import uwu.juni.wetland_whimsy.datapacks.Incense;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

@ParametersAreNonnullByDefault
public class AncientBrazierBlockEntity
extends BlockEntity
implements Spawner {
    AncientBrazierSpawner spawner = new AncientBrazierSpawner(){

        public Either<BlockEntity, Entity> getOwner() {
            return Either.left((Object)((Object)AncientBrazierBlockEntity.this));
        }
    };
    Optional<Item> currentIncense = Optional.empty();
    List<Item> usedIncenses = new ArrayList<Item>();
    private static String ERROR_MESSAGE = "\n-- What is this wierd creature in my world? --\n\n\nWhat you are seeing is `wetland_whimsy:silly`, an entity\nthat was initially created for testing purposes. However,\nthis entity has since then been reused as a default for\nIncense data files, as it should be pretty clear that when\nyou're seeing it, something has gone wrong.\n\n\nIf you are seeing this message, the most likely cause would\nbe that an item was tagged with `wetland_whimsy:incense`\nwithout having an incense data file to go along with it.\nIf that json file does exist, it may be invalid - please\ncheck it to see if its syntax is correct or if it is in a\nvalid location. \n\n\nIf you are playing a modpack, please report this to the\nmodpack's developer BEFORE reporting it to the Wetland\nWhimsy team.\n";

    public AncientBrazierBlockEntity(BlockPos pos, BlockState state) {
        super(WetlandWhimsyBlockEntities.ANCIENT_BRAZIER.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        Item item;
        super.loadAdditional(tag, registries);
        this.spawner.load(this.level, this.worldPosition, tag);
        Function<String, Item> strToItem = str -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)str));
        ListTag list = tag.getList("used_incenses", 8);
        if (list != null) {
            for (Tag str2 : list) {
                this.usedIncenses.add(strToItem.apply(str2.getAsString()));
            }
        }
        this.currentIncense = (item = strToItem.apply(tag.getString("current_incense"))) != null && new ItemStack((ItemLike)item).is(WetlandWhimsyTags.Items.INCENSE) ? Optional.of(item) : Optional.empty();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.spawner.save(tag);
        ListTag list = new ListTag();
        for (Item item : this.usedIncenses) {
            list.add((Object)StringTag.valueOf((String)item.toString()));
        }
        if (!list.isEmpty()) {
            tag.put("used_incenses", (Tag)list);
        }
        if (this.currentIncense.isPresent()) {
            tag.putString("current_incense", this.currentIncense.get().toString());
        }
    }

    public void setEntityId(EntityType<?> type, RandomSource random) {
        this.spawner.setEntityId(type, this.level, random, this.worldPosition);
        this.setChanged();
    }

    public boolean triggerEvent(int id, int type) {
        return this.level == null ? false : (this.spawner.onEventTriggered(this.level, id) ? true : super.triggerEvent(id, type));
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AncientBrazierBlockEntity blockEntity) {
        blockEntity.spawner.clientTick(level, pos);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AncientBrazierBlockEntity blockEntity) {
        blockEntity.spawner.serverTick((ServerLevel)level, pos);
    }

    public boolean trySetIncense(ItemLike item) {
        if (this.currentIncense.isPresent() || this.usedIncenses.contains(item.asItem())) {
            return false;
        }
        this.setChanged();
        this.currentIncense = Optional.of(item.asItem());
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            this.spawner.setRandomEntity(sLevel, this.worldPosition);
        }
        return true;
    }

    public boolean hasIncense() {
        return this.currentIncense.isPresent();
    }

    public Incense getIncense(ServerLevel level) {
        Set registries = level.getServer().registryAccess().registryOrThrow(Datapacks.INCENSE).entrySet();
        for (Map.Entry registry : registries) {
            Incense incense = (Incense)registry.getValue();
            if (incense.item() != this.currentIncense.get()) continue;
            return incense;
        }
        if (ERROR_MESSAGE != null) {
            WetlandWhimsy.LOGGER.warn(ERROR_MESSAGE);
        }
        ERROR_MESSAGE = null;
        return new Incense(Items.DIRT, WetlandWhimsy.rLoc(""), new Vector3f(0.0f, 0.0f, 0.0f), List.of(WetlandWhimsy.rLoc("silly")));
    }

    public void killIncense() {
        if (this.currentIncense.isPresent()) {
            this.usedIncenses.add(this.currentIncense.get());
        }
        this.currentIncense = Optional.empty();
    }
}

