/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyParticleTypes;
import uwu.juni.wetland_whimsy.datagen.registries.WetlandWhimsyConfiguredFeatures;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

@ParametersAreNonnullByDefault
public class BloodcapMushroomBlock
extends BushBlock
implements BonemealableBlock {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final MapCodec<BloodcapMushroomBlock> CODEC = BloodcapMushroomBlock.simpleCodec(BloodcapMushroomBlock::new);

    public BloodcapMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growMushroom(level, pos, state, random);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(25) == 0) {
            this.tryGrow((Level)level, pos, state, random, 4);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.getType().is(WetlandWhimsyTags.Entities.BLOODCAP_IMMUNE)) {
            return;
        }
        if (level.isClientSide || level.getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity lEntity = (LivingEntity)entity;
            lEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 50));
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        VoxelShape voxelshape = this.getShape(state, (BlockGetter)level, pos, CollisionContext.empty());
        Vec3 vec3 = voxelshape.bounds().getCenter();
        double d0 = (double)pos.getX() + vec3.x;
        double d1 = (double)pos.getZ() + vec3.z;
        for (int i = 0; i < 3; ++i) {
            if (random.nextInt(0, 4) != 0) continue;
            level.addParticle((ParticleOptions)WetlandWhimsyParticleTypes.BLOODCAP_SPORES.get(), d0 + random.nextDouble() / 5.0, (double)pos.getY() + (0.65 - random.nextDouble()), d1 + random.nextDouble() / 5.0, 0.0, 0.0, 0.0);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos new_pos = pos.below();
        BlockState new_state = level.getBlockState(new_pos);
        return new_state.is(BlockTags.LUSH_GROUND_REPLACEABLE) && new_state.isSolidRender((BlockGetter)level, new_pos);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isSolidRender(level, pos);
    }

    private void tryGrow(Level level, BlockPos pos, BlockState state, RandomSource random, int chance) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!level.getBlockState(blockpos).is((Block)this) || --chance > 0) continue;
            return;
        }
        BlockPos blockpos1 = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
        for (int i = 0; i < chance; ++i) {
            if (level.isEmptyBlock(blockpos1) && state.canSurvive((LevelReader)level, blockpos1)) {
                pos = blockpos1;
            }
            blockpos1 = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
        }
        if (level.isEmptyBlock(blockpos1) && state.canSurvive((LevelReader)level, blockpos1)) {
            level.setBlock(blockpos1, state, 2);
        }
    }

    boolean growMushroom(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        Optional<Holder> optional = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(WetlandWhimsyConfiguredFeatures.HUGE_BLOODCAP_MUSHROOM);
        BlockGrowFeatureEvent event = EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, (Holder)optional.orElse(null));
        if (event.isCanceled()) {
            return false;
        }
        optional = Optional.ofNullable(event.getFeature());
        if (optional.isEmpty()) {
            return false;
        }
        level.removeBlock(pos, false);
        if (((ConfiguredFeature)optional.get().value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos)) {
            return true;
        }
        level.setBlock(pos, state, 3);
        return false;
    }
}

