/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks;

import com.mojang.serialization.MapCodec;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AriaMushroomBlock
extends BushBlock
implements BonemealableBlock {
    private static Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    protected static final MapCodec<AriaMushroomBlock> CODEC = AriaMushroomBlock.simpleCodec(AriaMushroomBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);

    public AriaMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        BlockState x = super.getStateForPlacement(context);
        if (x == null) {
            return null;
        }
        Direction dir = context.getClickedFace().getOpposite();
        for (Direction d : DIRECTIONS) {
            if (d != dir) continue;
            return (BlockState)x.setValue(FACING, (Comparable)d);
        }
        return (BlockState)x.setValue(FACING, (Comparable)context.getHorizontalDirection());
    }

    protected VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public boolean isValidBonemealTarget(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(@Nonnull Level level, @Nonnull RandomSource random, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return true;
    }

    public void performBonemeal(@Nonnull ServerLevel level, @Nonnull RandomSource random, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.tryGrow((Level)level, pos, state, 18);
    }

    protected void randomTick(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (random.nextInt(25) == 0) {
            this.tryGrow((Level)level, pos, state, 4);
        }
    }

    protected boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        BlockPos new_pos = pos.relative((Direction)state.getValue(FACING));
        return level.getBlockState(new_pos).isSolidRender((BlockGetter)level, new_pos);
    }

    private void tryGrow(Level level, BlockPos pos, BlockState state, int chance) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int i = chance;
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-3, -3, -3), (BlockPos)pos.offset(3, 3, 3))) {
            if (!level.getBlockState(blockpos).is((Block)this) || --i > 0) continue;
            return;
        }
        Function<BlockPos, BlockPos> blockPosFn = oldPos -> oldPos.offset(random.nextInt(3) - random.nextInt(3), random.nextInt(3) - random.nextInt(3), random.nextInt(3) - random.nextInt(3));
        BlockPos blockpos1 = blockPosFn.apply(pos);
        for (int k = 0; k < chance; ++k) {
            if (level.isEmptyBlock(blockpos1) && this.canSurvive(level, blockpos1, state)) {
                pos = blockpos1;
            }
            blockpos1 = blockPosFn.apply(pos);
        }
        if (level.isEmptyBlock(blockpos1) && this.canSurvive(level, blockpos1, state)) {
            level.setBlock(blockpos1, this.getValidDir(level, blockpos1, state), 2);
        }
    }

    private boolean canSurvive(Level level, BlockPos pos, BlockState state) {
        for (Direction d : DIRECTIONS) {
            if (!(state = (BlockState)state.setValue(FACING, (Comparable)d)).canSurvive((LevelReader)level, pos)) continue;
            return true;
        }
        return false;
    }

    private BlockState getValidDir(Level level, BlockPos pos, BlockState state) {
        for (Direction d : DIRECTIONS) {
            if (!(state = (BlockState)state.setValue(FACING, (Comparable)d)).canSurvive((LevelReader)level, pos)) continue;
            return state;
        }
        return state;
    }
}

