/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.client.entities.crane;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.client.entities.crane.CraneAnimations;
import uwu.juni.wetland_whimsy.content.entities.CraneEntity;

public class CraneModel
extends HierarchicalModel<CraneEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WetlandWhimsy.rLoc("crane"), "main");
    private final ModelPart crane;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart body;
    private final ModelPart left_wing;
    private final ModelPart evil;

    public CraneModel(ModelPart root) {
        this.crane = root.getChild("crane");
        this.neck = this.crane.getChild("neck");
        this.head = this.neck.getChild("head");
        this.left_leg = this.crane.getChild("left_leg");
        this.right_leg = this.crane.getChild("right_leg");
        this.body = this.crane.getChild("body");
        this.left_wing = this.body.getChild("left_wing");
        this.evil = this.body.getChild("evil");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition crane = partdefinition.addOrReplaceChild("crane", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition neck = crane.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.0f, (float)-4.0f));
        PartDefinition cube_r1 = neck.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(44, 10).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(18, 46).addBox(0.0f, -2.0f, -6.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)1.0f));
        PartDefinition left_leg = crane.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition lower_r1 = left_leg.addOrReplaceChild("lower_r1", CubeListBuilder.create().texOffs(26, 46).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)8.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition upper_r1 = left_leg.addOrReplaceChild("upper_r1", CubeListBuilder.create().texOffs(38, 40).addBox(-2.0f, -6.0f, -1.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)3.0f, (float)1.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = crane.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition upper_r2 = right_leg.addOrReplaceChild("upper_r2", CubeListBuilder.create().texOffs(44, 0).addBox(-2.0f, -6.0f, -1.0f, 3.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)3.0f, (float)1.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition lower_r2 = right_leg.addOrReplaceChild("lower_r2", CubeListBuilder.create().texOffs(30, 46).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)8.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition body = crane.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 40).addBox(-2.0f, -9.0f, 8.0f, 4.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -8.0f, -1.0f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-12.0f, (float)-5.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = body.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)-18.0f, (float)-2.0f));
        PartDefinition cube_r2 = left_wing.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 22).addBox(0.0f, -0.6232f, -0.6995f, 1.0f, 6.0f, 12.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition evil = body.addOrReplaceChild("evil", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)-18.0f, (float)-2.0f));
        PartDefinition cube_r3 = evil.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(26, 22).addBox(0.0f, -0.6232f, -0.6995f, 1.0f, 6.0f, 12.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@Nonnull CraneEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.crane.getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(CraneAnimations.WALK, limbSwing, limbSwingAmount, 1.0f, 1.0f);
        this.animate(entity.idleAnimationState, CraneAnimations.IDLE, ageInTicks, 1.0f);
        this.animate(entity.flyAnimationState, CraneAnimations.FLY, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart root() {
        return this.crane;
    }

    public void renderToBuffer(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.crane.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

