/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.client.entities.blemish;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.client.entities.blemish.BlemishAnimations;
import uwu.juni.wetland_whimsy.content.entities.BlemishEntity;

public class BlemishModel<T extends BlemishEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WetlandWhimsy.rLoc("blemish"), "main");
    private final ModelPart model_base;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart tail;

    public BlemishModel(ModelPart root) {
        this.model_base = root.getChild("model_base");
        this.left_arm = this.model_base.getChild("left_arm");
        this.right_arm = this.model_base.getChild("right_arm");
        this.body = this.model_base.getChild("body");
        this.head = this.model_base.getChild("head");
        this.tail = this.model_base.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition model_base = partdefinition.addOrReplaceChild("model_base", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_arm = model_base.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition left_arm_r1 = left_arm.addOrReplaceChild("left_arm_r1", CubeListBuilder.create().texOffs(32, 23).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.0f, (float)8.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition right_arm = model_base.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition right_arm_r1 = right_arm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(32, 23).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)8.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition body = model_base.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition rib_large_left_r1 = body.addOrReplaceChild("rib_large_left_r1", CubeListBuilder.create().texOffs(34, 12).addBox(-3.0f, -2.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(34, 12).mirror().addBox(-11.0f, -2.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)-5.0f, (float)2.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition rib_small_left_r1 = body.addOrReplaceChild("rib_small_left_r1", CubeListBuilder.create().texOffs(35, 8).addBox(-2.0f, -1.75f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(35, 8).mirror().addBox(-9.0f, -1.75f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)-3.0f, (float)5.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(2, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)1.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition head = model_base.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 17).addBox(-4.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition tail = model_base.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(12, 2).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)13.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@Nonnull BlemishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(BlemishAnimations.BLEMISH_WALK, limbSwing, limbSwingAmount, 3.5f, 2.5f);
        this.animate(entity.idleAnimationState, BlemishAnimations.BLEMISH_IDLE, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.zRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.model_base.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.model_base;
    }
}

