/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.terraformersmc.biolith.api.biome.BiomePlacement;
import com.terraformersmc.biolith.api.biome.sub.BiomeParameterTargets;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import com.terraformersmc.biolith.api.biome.sub.CriterionBuilder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyAdvancementTriggers;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlockEntities;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyEntityTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyFeatures;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyParticleTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyPotPatterns;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;
import uwu.juni.wetland_whimsy.datagen.registries.WetlandWhimsyBiomes;
import uwu.juni.wetland_whimsy.misc.WetlandWhimsyCompat;
import uwu.juni.wetland_whimsy.misc.WetlandWhimsyConfig;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyWoodTypes;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyBiomeModifiers;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyFoliagePlacers;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTreeDecorators;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTrunkPlacers;

@Mod(value="wetland_whimsy")
public class WetlandWhimsy {
    public static final String MODID = "wetland_whimsy";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final ImmutableList<DeferredRegister<?>> REGISTRIES = ImmutableList.of(WetlandWhimsyAdvancementTriggers.TRIGGERS, (Object)WetlandWhimsyBlocks.BLOCKS, WetlandWhimsyBlockEntities.BLOCK_ENTITY_TYPES, WetlandWhimsyEntityTypes.ENTITIES, WetlandWhimsyFeatures.FEATURES, (Object)WetlandWhimsyItems.ITEMS, WetlandWhimsyParticleTypes.PARTICLE_TYPES, WetlandWhimsyPotPatterns.PATTERNS, WetlandWhimsySounds.SOUNDS, WetlandWhimsyFoliagePlacers.FOLIAGE_PLACERS, WetlandWhimsyTrunkPlacers.TRUNK_PLACERS, WetlandWhimsyTreeDecorators.TREE_DECORATORS, (Object[])new DeferredRegister[]{WetlandWhimsyBiomeModifiers.BIOME_MODIFIERS});

    public WetlandWhimsy(IEventBus bussin, ModContainer mc, Dist dist) {
        LOGGER.info("Whimsical");
        this.config(mc, dist);
        for (DeferredRegister registry : REGISTRIES) {
            registry.register(bussin);
        }
        WetlandWhimsyBlocks.createSignItems();
        WetlandWhimsyWoodTypes.registerWoodTypes();
        bussin.addListener(WetlandWhimsy::commonSetup);
    }

    void config(ModContainer mc, Dist dist) {
        mc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WetlandWhimsyConfig.SPEC);
        if (dist == Dist.CLIENT) {
            mc.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    static void commonSetup(FMLCommonSetupEvent a) {
        WetlandWhimsyPotPatterns.initPotPatterns();
        WetlandWhimsyCompat.compat();
        WetlandWhimsy.marshification();
    }

    static void marshification() {
        if (!((Boolean)WetlandWhimsyConfig.GENERATE_MARSH.get()).booleanValue()) {
            return;
        }
        BiomePlacement.addSubOverworld((ResourceKey)Biomes.SWAMP, WetlandWhimsyBiomes.MARSH, (Criterion)CriterionBuilder.deviationMax((BiomeParameterTargets)BiomeParameterTargets.CONTINENTALNESS, (float)-0.44f));
    }

    public static ResourceLocation rLoc(String loc) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)loc);
    }

    public static <T> DeferredRegister<T> registry(ResourceKey<Registry<T>> registry) {
        return DeferredRegister.create(registry, (String)MODID);
    }
}

