/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record RandomAdventurerMapListing(Item emerald, int priceMin, int priceMax, Optional<ItemCost> priceSecondary, int maxTrades, float priceMult, int level) implements ModItemListing
{
    public static final MapCodec<RandomAdventurerMapListing> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("item", (Object)Items.EMERALD).forGetter(RandomAdventurerMapListing::emerald), (App)Codec.INT.fieldOf("price_min").forGetter(RandomAdventurerMapListing::priceMin), (App)Codec.INT.fieldOf("price_max").forGetter(RandomAdventurerMapListing::priceMax), (App)ItemCost.CODEC.optionalFieldOf("price_secondary").forGetter(RandomAdventurerMapListing::priceSecondary), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_trades", (Object)16).forGetter(RandomAdventurerMapListing::maxTrades), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(RandomAdventurerMapListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(RandomAdventurerMapListing::level)).apply((Applicative)i, RandomAdventurerMapListing::new));

    public MerchantOffer getOffer(@NotNull Entity entity, @NotNull RandomSource random) {
        int emeraldCost = random.nextInt(this.priceMax - this.priceMin + 1) + this.priceMax;
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack result = AdventurerMapsHandler.createMapOrQuill(serverLevel, entity.blockPosition(), null, 150, true, 2, null, "filled_map.adventure", 7869722);
            if (result.isEmpty()) {
                return null;
            }
            int x = 6;
            int xp = (int)((float)(x * 12) / (float)this.maxTrades);
            return new MerchantOffer(new ItemCost((ItemLike)this.emerald, emeraldCost), this.priceSecondary, result, this.maxTrades, xp, this.priceMult);
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }
}

