/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PedestalBlock;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.EndCrystalItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class PedestalBlockTile
extends ItemDisplayTile {
    private DisplayType type = DisplayType.ITEM;

    public PedestalBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.PEDESTAL_TILE.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return AABB.encapsulatingFullBlocks((BlockPos)this.worldPosition, (BlockPos)this.worldPosition.offset(1, 2, 1));
    }

    public DisplayType getDisplayType() {
        return this.type;
    }

    public void updateTileOnInventoryChanged() {
        ItemStack stack;
        Item it;
        boolean hasItem;
        BlockState newState;
        BlockState state = this.getBlockState();
        if (state != (newState = (BlockState)((BlockState)state.setValue(PedestalBlock.ITEM_STATUS, (Comparable)((Object)PedestalBlock.getStatus((LevelAccessor)this.level, this.worldPosition, hasItem = !this.isEmpty())))).setValue((Property)PedestalBlock.UP, (Comparable)Boolean.valueOf(PedestalBlock.canConnectTo(this.level.getBlockState(this.worldPosition.above()), this.worldPosition, (LevelAccessor)this.level, Direction.UP, hasItem))))) {
            this.level.setBlock(this.worldPosition, newState, 3);
            if (!((ModBlockProperties.DisplayStatus)((Object)state.getValue(PedestalBlock.ITEM_STATUS))).hasTile()) {
                this.level.removeBlockEntity(this.worldPosition);
            }
        }
        this.type = MiscUtils.isSword(it = (stack = this.getDisplayedItem()).getItem()) || stack.is(ModTags.PEDESTAL_DOWNRIGHT) ? DisplayType.SWORD : (it instanceof TridentItem || stack.is(ModTags.PEDESTAL_UPRIGHT) ? DisplayType.TRIDENT : (it instanceof EndCrystalItem ? DisplayType.CRYSTAL : (it == ModRegistry.GLOBE_ITEM.get() ? DisplayType.GLOBE : (it == ModRegistry.GLOBE_SEPIA_ITEM.get() ? DisplayType.SEPIA_GLOBE : (it instanceof BlockItem ? DisplayType.BLOCK : DisplayType.ITEM)))));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.type = DisplayType.values()[tag.getInt("Type")];
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("Type", this.type.ordinal());
    }

    public Component getDefaultName() {
        return Component.translatable((String)"gui.supplementaries.pedestal");
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public static enum DisplayType {
        ITEM,
        BLOCK,
        SWORD,
        TRIDENT,
        CRYSTAL,
        GLOBE,
        SEPIA_GLOBE;


        public boolean isGlobe() {
            return this == GLOBE || this == SEPIA_GLOBE;
        }
    }
}

