/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import java.util.Arrays;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.block.IOnePlayerInteractable;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetTextHolderPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class TextHolderEditScreen<T extends BlockEntity>
extends Screen {
    protected final T tile;
    protected final String[][] messages;
    protected final int totalLines;
    protected TextFieldHelper textInputUtil;
    protected int lineIndex = 0;
    protected int textHolderIndex = 0;
    protected int updateCounter;

    protected TextHolderEditScreen(T tile, Component title) {
        super(title);
        this.tile = tile;
        boolean filtering = Minecraft.getInstance().isTextFilteringEnabled();
        this.messages = (String[][])IntStream.range(0, ((ITextHolderProvider)tile).textHoldersCount()).mapToObj(i -> (String[])IntStream.range(0, ((ITextHolderProvider)tile).getTextHolder(i).size()).mapToObj(j -> ((ITextHolderProvider)tile).getTextHolder(i).getMessage(j, filtering)).map(Component::getString).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
        this.totalLines = Arrays.stream(this.messages).mapToInt(innerArray -> ((String[])innerArray).length).sum();
    }

    public boolean charTyped(char codePoint, int modifiers) {
        this.textInputUtil.charTyped(codePoint);
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean old = super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        boolean n = this.scrollText((int)scrollY);
        return old || n;
    }

    protected boolean canScroll() {
        return true;
    }

    protected boolean scrollText(int amount) {
        if (this.canScroll()) {
            this.lineIndex -= amount;
            while (this.lineIndex < 0) {
                this.lineIndex += this.totalLines;
            }
            while (this.lineIndex >= this.messages[this.textHolderIndex].length) {
                this.lineIndex -= this.messages[this.textHolderIndex].length;
                ++this.textHolderIndex;
                this.textHolderIndex %= this.messages.length;
            }
            this.textInputUtil.setCursorToEnd();
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.scrollText(1);
            return true;
        }
        if (keyCode != 264 && keyCode != 257 && keyCode != 335) {
            return this.textInputUtil.keyPressed(keyCode) || super.keyPressed(keyCode, scanCode, modifiers);
        }
        this.scrollText(-1);
        return true;
    }

    public void tick() {
        ++this.updateCounter;
        if (!this.isValid()) {
            this.onClose();
        }
    }

    private boolean isValid() {
        return this.minecraft != null && this.minecraft.player != null && !this.tile.isRemoved() && ((IOnePlayerInteractable)this.tile).isEditingPlayer(this.tile.getBlockPos(), (Player)this.minecraft.player);
    }

    public void onClose() {
        this.tile.setChanged();
        super.onClose();
    }

    public void removed() {
        NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundSetTextHolderPacket(this.tile.getBlockPos(), this.messages));
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 100, this.height / 4 + 144, 200, 20).build());
        this.textInputUtil = new TextFieldHelper(() -> this.messages[this.textHolderIndex][this.lineIndex], h -> {
            this.messages[this.textHolderIndex][this.lineIndex] = h;
            ((ITextHolderProvider)this.tile).getTextHolder(this.textHolderIndex).setMessage(this.lineIndex, (Component)Component.literal((String)h));
        }, TextFieldHelper.createClipboardGetter((Minecraft)this.minecraft), TextFieldHelper.createClipboardSetter((Minecraft)this.minecraft), s -> this.minecraft.font.width(s) <= ((ITextHolderProvider)this.tile).getTextHolder(this.textHolderIndex).getMaxLineVisualWidth());
    }
}

