/*
 * Decompiled with CFR 0.152.
 */
package baguchan.revampedwolf.entity.goal;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LeapAtTargetWolfGoal
extends Goal {
    private static final ObjectArrayList<Integer> ALLOWED_ANGLES = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 45, 50, 55, 58}));
    private final Mob mob;
    protected final float maxJumpVelocityMultiplier;
    private LivingEntity target;
    private int jumpCooldown;

    public LeapAtTargetWolfGoal(Mob p_25492_, float maxJumpVelocityMultiplier) {
        this.mob = p_25492_;
        this.maxJumpVelocityMultiplier = maxJumpVelocityMultiplier;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        double d0;
        if (this.mob.hasControllingPassenger()) {
            return false;
        }
        this.target = this.mob.getTarget();
        if (this.target == null) {
            return false;
        }
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if ((d0 = (double)this.mob.distanceTo((Entity)this.target)) < 0.5 || d0 > 3.0) {
            return false;
        }
        return this.mob.onGround() && this.jumpCooldown <= 0;
    }

    public boolean canContinueToUse() {
        return !this.mob.onGround();
    }

    public void stop() {
        super.stop();
        this.mob.setDiscardFriction(false);
        this.jumpStop(this.mob);
    }

    public void start() {
        this.jumpCooldown = 20 + this.mob.getRandom().nextInt(20);
        BlockPos blockpos = LeapAtTargetWolfGoal.snapToSurface((LivingEntity)this.mob, this.target.position());
        if (blockpos != null) {
            BlockState blockstate = this.mob.level().getBlockState(blockpos.below());
            if (!this.mob.getType().isBlockDangerous(blockstate) && (LeapAtTargetWolfGoal.hasLineOfSight((LivingEntity)this.mob, blockpos.getCenter()) || LeapAtTargetWolfGoal.hasLineOfSight((LivingEntity)this.mob, blockpos.above(4).getCenter()))) {
                Vec3 vec32 = this.calculateOptimalJumpVector(this.mob, this.mob.getRandom(), Vec3.atBottomCenterOf((Vec3i)blockpos)).orElse(null);
                if (vec32 == null) {
                    return;
                }
                this.mob.setDiscardFriction(true);
                this.mob.setDeltaMovement(vec32);
            }
        }
        this.jumpStart(this.mob);
    }

    public void jumpStart(Mob mob) {
        this.mob.playSound(SoundEvents.GOAT_LONG_JUMP);
    }

    public void jumpStop(Mob mob) {
    }

    public static boolean hasLineOfSight(LivingEntity p_316785_, Vec3 p_316249_) {
        Vec3 vec3 = new Vec3(p_316785_.getX(), p_316785_.getY(), p_316785_.getZ());
        return p_316249_.distanceTo(vec3) > 50.0 ? false : p_316785_.level().clip(new ClipContext(vec3, p_316249_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p_316785_)).getType() == HitResult.Type.MISS;
    }

    @Nullable
    private static BlockPos snapToSurface(LivingEntity p_311909_, Vec3 p_312597_) {
        ClipContext clipcontext = new ClipContext(p_312597_, p_312597_.relative(Direction.DOWN, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p_311909_);
        BlockHitResult hitresult = p_311909_.level().clip(clipcontext);
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            return BlockPos.containing((Position)hitresult.getLocation()).above();
        }
        ClipContext clipcontext1 = new ClipContext(p_312597_, p_312597_.relative(Direction.UP, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p_311909_);
        BlockHitResult hitresult1 = p_311909_.level().clip(clipcontext1);
        return hitresult1.getType() == HitResult.Type.BLOCK ? BlockPos.containing((Position)hitresult1.getLocation()).above() : null;
    }

    private Optional<Vec3> calculateOptimalJumpVector(Mob p_312651_, RandomSource p_312364_, Vec3 p_312758_) {
        Iterator iterator = Util.shuffledCopy(ALLOWED_ANGLES, (RandomSource)p_312364_).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            float f = (float)(p_312651_.getAttributeValue(Attributes.JUMP_STRENGTH) * (double)this.maxJumpVelocityMultiplier);
            Optional optional = LongJumpUtil.calculateJumpVectorForAngle((Mob)p_312651_, (Vec3)p_312758_, (float)f, (int)i, (boolean)true);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }
}

