/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.screen;

import com.epherical.serverbrowser.ServerQuery;
import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.Filter;
import com.epherical.serverbrowser.client.ServerPinger;
import com.epherical.serverbrowser.client.list.ServerBrowserList;
import com.epherical.serverbrowser.client.screen.FilterServerScreen;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerBrowserScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServerPinger pinger = new ServerPinger();
    protected ServerBrowserList list;
    private Button joinButton;
    private Button favoriteButton;
    private Button next;
    private Button prev;
    @Nullable
    private List<Component> toolTip;
    private Component websiteStatus;
    private Screen previousScreen;
    private int page = 1;
    private boolean initedOnce;

    public ServerBrowserScreen(Screen previousScreen) {
        super(Component.nullToEmpty((String)""));
        this.previousScreen = previousScreen;
    }

    protected void init() {
        this.list = new ServerBrowserList(this, this.minecraft, this.width, this.height - 64 - 32, 0, 32);
        this.list.setRectangle(this.width, this.height - 64 - 32, 0, 32);
        this.queryServers();
        this.list.queryServers();
        this.addRenderableWidget((GuiEventListener)this.list);
        this.next = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"serverbrowser.button.next_page", (Object[])new Object[]{this.page + 1}), button -> {
            if (this.list.getEntries().size() >= 20) {
                ++this.page;
                this.queryServers();
                this.list.queryServers();
                button.setMessage((Component)Component.translatable((String)"serverbrowser.button.next_page", (Object[])new Object[]{this.page + 1}));
            }
        }).bounds(this.width - 110, 12, 60, 20).build());
        this.prev = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"serverbrowser.button.prev_page"), button -> {
            if (this.page <= 1) {
                this.page = 1;
            } else {
                --this.page;
                this.queryServers();
                this.list.queryServers();
            }
            this.next.setMessage((Component)Component.translatable((String)"serverbrowser.button.next_page", (Object[])new Object[]{this.page + 1}));
        }).bounds(this.width - 140, 12, 30, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"serverbrowser.button.register"), button -> this.minecraft.setScreen((Screen)new ConfirmLinkScreen(bl -> {
            if (bl) {
                Util.getPlatform().openUri("https://minecraft.multiplayerservers.net");
            }
            this.minecraft.setScreen((Screen)this);
        }, "https://minecraft.multiplayerservers.net", true))).bounds(this.width / 2 - 50, 3, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"serverbrowser.button.filter"), button -> this.minecraft.setScreen((Screen)new FilterServerScreen(this))).bounds(this.width / 2 - 50, this.height - 52, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"selectServer.refresh"), button -> this.refreshServerList()).bounds(this.width / 2 - 80, this.height - 28, 156, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()))).bounds(this.width / 2 + 4 + 76, this.height - 28, 75, 20).build());
        this.addWidget((GuiEventListener)this.list);
        this.onSelectedChange();
    }

    public void render(GuiGraphics poseStack, int mouseX, int mouseY, float partialTick) {
        this.toolTip = null;
        super.render(poseStack, mouseX, mouseY, partialTick);
        if (this.toolTip != null) {
            poseStack.renderComponentTooltip(this.minecraft.font, this.toolTip, mouseX, mouseY);
        }
        this.next.active = false;
        this.prev.active = false;
        if (this.list.getEntries().size() >= 20) {
            this.next.active = true;
        }
        if (this.page > 1) {
            this.prev.active = true;
        }
        if (this.websiteStatus != null) {
            poseStack.drawCenteredString(this.minecraft.font, this.websiteStatus, this.width / 2, 40, 0xFFFFFF);
        }
    }

    public void queryServers() {
        this.websiteStatus = null;
        ServerQuery main = new ServerQuery(CommonClient.URL + "/api/v1/servers", builder -> {
            if (this.page > 1) {
                builder.addParameter("page", String.valueOf(this.page));
            }
            for (Filter filter : CommonClient.getInstance().getFilters()) {
                if (!filter.isActive()) continue;
                builder.addParameter("type", filter.getTagName());
            }
        }, throwable -> {
            this.websiteStatus = Component.translatable((String)"serverbrowser.error.unreachable_website");
            return "";
        }, (s, throwable) -> {
            this.websiteStatus = null;
        });
        main.buildList(main.runQuery(), this.list, false);
        String packID = CommonClient.getInstance().getConfig().bisectPackID;
        if (packID.length() > 0 && this.page <= 1) {
            ServerQuery bisect = new ServerQuery("https://www.bisecthosting.com/api/v1/public_servers", builder -> builder.addParameter("id", packID), throwable -> {
                LOGGER.warn("Could not ping bisect's servers", throwable);
                return "";
            }, (s, throwable) -> {});
            bisect.buildList(bisect.runQuery(), this.list, true);
        }
        this.websiteStatus = Component.translatable((String)"serverbrowser.error.unreachable_website");
    }

    public void setSelected(ServerBrowserList.Entry selected) {
        this.list.setSelected((AbstractSelectionList.Entry)selected);
        this.onSelectedChange();
    }

    protected void onSelectedChange() {
        ServerBrowserList.Entry entry = (ServerBrowserList.Entry)this.list.getSelected();
        if (entry instanceof ServerBrowserList.BrowsedEntry) {
            // empty if block
        }
    }

    public void joinSelectedServer() {
        ServerBrowserList.Entry entry = (ServerBrowserList.Entry)this.list.getSelected();
        if (entry instanceof ServerBrowserList.BrowsedEntry) {
            this.join(((ServerBrowserList.BrowsedEntry)entry).getServerData());
        }
    }

    private void join(ServerData server) {
        ConnectScreen.startConnecting((Screen)this, (Minecraft)this.minecraft, (ServerAddress)ServerAddress.parseString((String)server.ip), (ServerData)server, (boolean)false, null);
    }

    private void refreshServerList() {
        this.list.refreshServers();
    }

    public ServerPinger getPinger() {
        return this.pinger;
    }

    public void setToolTip(List<Component> toolTip) {
        this.toolTip = toolTip;
    }
}

