/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.screen;

import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.Filter;
import com.epherical.serverbrowser.client.list.TagList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.http.client.utils.URIBuilder;

public class FilterServerScreen
extends Screen {
    private final Screen previousScreen;
    private Component websiteStatus;
    protected TagList list;

    protected FilterServerScreen(Screen previousScreen) {
        super((Component)Component.translatable((String)"serverbrowser.button.filter"));
        this.previousScreen = previousScreen;
    }

    protected void init() {
        this.queryTags();
        this.list = new TagList(this, this.minecraft, this.width, this.height - 64, 0, 25);
        this.list.setRectangle(this.width, this.height - 64 - 32, 0, 32);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (TagList.Entry child : this.list.children()) {
                for (GuiEventListener listener : child.children()) {
                    Checkbox checkbox = (Checkbox)listener;
                    String string = checkbox.getMessage().getString();
                    boolean active = checkbox.selected();
                    filters.add(new Filter(string, active));
                }
            }
            CommonClient.getInstance().clearAndReset(filters);
            this.minecraft.setScreen(this.previousScreen);
        }).bounds(this.width / 2 + 4 + 76, this.height - 28, 75, 20).build());
        this.addRenderableWidget((GuiEventListener)this.list);
    }

    public void queryTags() {
        this.websiteStatus = null;
        try {
            URIBuilder builder = new URIBuilder(CommonClient.URL + "/api/v1/tags");
            URL url = builder.build().toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                byte[] bytes = connection.getInputStream().readAllBytes();
                String string = new String(bytes);
                JsonArray element = JsonParser.parseString((String)string).getAsJsonArray();
                for (JsonElement jsonElement : element) {
                    JsonObject object = jsonElement.getAsJsonObject();
                    String tagName = object.get("tagName").getAsString();
                    String category = object.get("category").getAsString();
                    if (!CommonClient.getInstance().getConfig().modPackFilter.isEmpty() && category.equals("Modpack")) continue;
                    ArrayList<Filter> filterList = new ArrayList<Filter>();
                    filterList.add(new Filter(tagName));
                    CommonClient.getInstance().mergeFilters(filterList);
                }
            }
            connection.disconnect();
        }
        catch (IOException | URISyntaxException e) {
            this.websiteStatus = Component.translatable((String)"serverbrowser.error.unreachable_website");
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.list.render(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.websiteStatus != null) {
            graphics.drawCenteredString(this.minecraft.font, this.websiteStatus, this.width / 2, 40, 0xFFFFFF);
        }
    }
}

