/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.list;

import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.Filter;
import com.epherical.serverbrowser.client.screen.FilterServerScreen;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;

public class TagList
extends ContainerObjectSelectionList<Entry> {
    public TagList(FilterServerScreen screen, Minecraft minecraft, int i, int j, int k, int l) {
        super(minecraft, i, j, k, l);
        Iterable partition = Iterables.partition((Iterable)CommonClient.getInstance().getFilters().stream().sorted(Comparator.comparing(Filter::isActive).reversed().thenComparing(Filter::getTagName)).collect(Collectors.toList()), (int)2);
        partition.forEach(filters -> {
            TagEntry entry = new TagEntry(this, filters.toArray(new Filter[0]));
            this.addEntry((AbstractSelectionList.Entry)entry);
        });
    }

    protected int getScrollbarPosition() {
        return this.width - 10;
    }

    public int getRowWidth() {
        return this.width - 10;
    }

    public class TagEntry
    extends Entry {
        private static int widest = 0;
        private final List<Checkbox> checkboxes = new ArrayList<Checkbox>();

        public TagEntry(TagList this$0, Filter ... checkboxes) {
            for (Filter checkbox : checkboxes) {
                int width = ((TagList)this$0).minecraft.font.width(checkbox.getTagName()) + 20;
                this.checkboxes.add(Checkbox.builder((Component)Component.literal((String)checkbox.getTagName()), (Font)((TagList)this$0).minecraft.font).pos(0, 0).maxWidth(width + 5).selected(checkbox.isActive()).build());
            }
        }

        public void render(GuiGraphics poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            int itemWidth = 0;
            int increment = 0;
            for (Checkbox checkbox : this.checkboxes) {
                checkbox.setX(left + itemWidth);
                checkbox.setY(top);
                if (increment == 0 && (itemWidth += checkbox.getWidth()) >= widest) {
                    widest = itemWidth;
                }
                if (increment == 1) {
                    checkbox.setX(left + widest);
                }
                checkbox.render(poseStack, mouseX, mouseY, partialTick);
                ++increment;
            }
            increment = 0;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.checkboxes;
        }

        public List<? extends GuiEventListener> children() {
            return this.checkboxes;
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

