/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.list;

import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.screen.ServerBrowserScreen;
import com.epherical.serverbrowser.mixin.AccessorAbstractSelectionList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerBrowserList
extends ObjectSelectionList<Entry> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("ServerBrowser Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    static final ResourceLocation INCOMPATIBLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/incompatible");
    static final ResourceLocation UNREACHABLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/unreachable");
    static final ResourceLocation PING_1_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/ping_1");
    static final ResourceLocation PING_2_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/ping_2");
    static final ResourceLocation PING_3_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/ping_3");
    static final ResourceLocation PING_4_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/ping_4");
    static final ResourceLocation PING_5_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/ping_5");
    static final ResourceLocation PINGING_1_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/pinging_1");
    static final ResourceLocation PINGING_2_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/pinging_2");
    static final ResourceLocation PINGING_3_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/pinging_3");
    static final ResourceLocation PINGING_4_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/pinging_4");
    static final ResourceLocation PINGING_5_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/pinging_5");
    static final ResourceLocation JOIN_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/join_highlighted");
    static final ResourceLocation JOIN_SPRITE = ResourceLocation.withDefaultNamespace((String)"server_list/join");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller_background");
    private static final ResourceLocation MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/menu_list_background.png");
    private static final ResourceLocation INWORLD_MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/inworld_menu_list_background.png");
    static final Component SCANNING_LABEL = Component.translatable((String)"lanServer.scanning");
    static final Component CANT_RESOLVE_TEXT = Component.translatable((String)"multiplayer.status.cannot_resolve").withColor(-65536);
    static final Component CANT_CONNECT_TEXT = Component.translatable((String)"multiplayer.status.cannot_connect").withColor(-65536);
    static final Component INCOMPATIBLE_STATUS = Component.translatable((String)"multiplayer.status.incompatible");
    static final Component NO_CONNECTION_STATUS = Component.translatable((String)"multiplayer.status.no_connection");
    static final Component PINGING_STATUS = Component.translatable((String)"multiplayer.status.pinging");
    static final Component ONLINE_STATUS = Component.translatable((String)"multiplayer.status.online");
    private final ServerBrowserScreen screen;
    private final List<BrowsedEntry> entries = new ArrayList<BrowsedEntry>();

    public ServerBrowserList(ServerBrowserScreen screen, Minecraft minecraft, int i, int j, int k, int l) {
        super(minecraft, i, j, k, l);
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        AccessorAbstractSelectionList obj = (AccessorAbstractSelectionList)((Object)this);
        obj.setHovered(this.isMouseOver(mouseX, mouseY) ? this.getEntry(mouseX, mouseY) : null);
        this.renderListBackground(guiGraphics);
        this.enableScissor(guiGraphics);
        if (obj.isRenderHeader()) {
            int i = this.getRowLeft();
            int j = this.getY() + 4 - (int)this.getScrollAmount();
            this.renderHeader(guiGraphics, i, j);
        }
        this.renderListItems(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.disableScissor();
        this.renderListSeparators(guiGraphics);
        if (this.scrollbarVisible()) {
            int l = this.getScrollbarPosition();
            int i1 = (int)((float)(this.height * this.height) / (float)this.getMaxPosition());
            i1 = Mth.clamp((int)i1, (int)32, (int)(this.height - 8));
            int k = (int)this.getScrollAmount() * (this.height - i1) / this.getMaxScroll() + this.getY();
            if (k < this.getY()) {
                k = this.getY();
            }
            RenderSystem.enableBlend();
            guiGraphics.blitSprite(SCROLLER_BACKGROUND_SPRITE, l, this.getY(), 6, this.getHeight());
            guiGraphics.blitSprite(SCROLLER_SPRITE, l, k, 6, i1);
            RenderSystem.disableBlend();
        }
        this.renderDecorations(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected Entry getEntry(int index) throws IndexOutOfBoundsException {
        return (Entry)super.getEntry(index);
    }

    protected void renderItem(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            Entry e = this.getEntry(index);
            e.renderBack(guiGraphics, index, top, left, width, height, mouseX, mouseY, Objects.equals(this.getHovered(), (Object)e), partialTick);
            if (this.isSelectedItem(index)) {
                int i = this.isFocused() ? -1 : -8355712;
                this.renderSelection(guiGraphics, top, width, height, i, -16777216);
            }
            e.render(guiGraphics, index, top, left, width, height, mouseX, mouseY, Objects.equals(this.getHovered(), (Object)e), partialTick);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected Entry getEntry(double mouseX, double mouseY) {
        int i = this.getX() + this.width;
        int j = this.getX() + this.width;
        int k = j - i;
        int l = j + i;
        int i1 = Mth.floor((double)(mouseY - (double)this.getY())) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int j1 = i1 / this.itemHeight;
        return mouseX >= (double)k && mouseX <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.getItemCount() ? (Entry)((Object)this.children().get(j1)) : null;
    }

    protected void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
    }

    public void refreshServers() {
        for (BrowsedEntry entry : this.entries) {
            entry.getServerData().setState(ServerData.State.INITIAL);
        }
    }

    public int getRowLeft() {
        return this.getX() + 5;
    }

    public List<BrowsedEntry> getEntries() {
        return this.entries;
    }

    public void queryServers() {
        this.entries.clear();
        this.clearEntries();
    }

    public void addEntries(JsonElement jsonElement, boolean toTop) {
        JsonArray array = new JsonArray();
        array = jsonElement.getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject object = (JsonObject)element;
            BrowsedEntry browsedEntry = toTop ? new BrowsedEntry(this.screen, object.get("name").getAsString(), object.get("ip").getAsString(), object.get("port").getAsInt(), this.minecraft) : new BrowsedEntry(this.screen, object, this.minecraft);
            if (!browsedEntry.isValid()) continue;
            this.entries.add(browsedEntry);
            if (toTop) {
                this.addEntryToTop((AbstractSelectionList.Entry)browsedEntry);
                continue;
            }
            this.addEntry((AbstractSelectionList.Entry)browsedEntry);
        }
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    public int getRowWidth() {
        return super.getRowWidth() + this.width - super.getRowWidth() - 12;
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }

    public class BrowsedEntry
    extends Entry {
        private final ServerBrowserScreen screen;
        private final String serverName;
        private final String ipAddress;
        private final int port;
        private final Component description;
        private final List<String> tags;
        private final int rank;
        private final int bgColor;
        @Nullable
        private byte[] lastIconB64;
        private FaviconTexture icon;
        @Nullable
        private List<Component> onlinePlayersTooltip;
        @Nullable
        private ResourceLocation statusIcon;
        @Nullable
        private Component statusIconTooltip;
        private final Minecraft minecraft;
        private ServerData serverData;
        private long lastClickTime;
        private boolean valid = true;
        private AtomicBoolean validServer = new AtomicBoolean(true);

        public BrowsedEntry(ServerBrowserScreen screen, String serverName, String ipAddress, int port, Minecraft minecraft) {
            this.screen = screen;
            int strLen = serverName.length();
            this.serverName = strLen <= 45 ? serverName : serverName.substring(0, 45);
            this.ipAddress = ipAddress;
            this.port = port;
            this.description = Component.literal((String)"Unknown server from 3rd party service.");
            this.rank = 0;
            this.bgColor = 2188223;
            this.minecraft = minecraft;
            this.tags = new ArrayList<String>();
            this.assignCommonData();
        }

        public BrowsedEntry(ServerBrowserScreen screen, JsonObject object, Minecraft minecraft) {
            this.screen = screen;
            String serverName = object.get("serverName").getAsString();
            int strLen = serverName.length();
            this.serverName = strLen <= 40 ? serverName : serverName.substring(0, 40);
            this.ipAddress = object.get("ipAddress").getAsString();
            this.port = object.get("port").getAsInt();
            String address = this.ipAddress.toLowerCase(Locale.ROOT);
            if (CommonClient.getInstance().getConfig().blacklistedServers.contains(address)) {
                this.valid = false;
            }
            this.description = Component.literal((String)object.get("description").getAsString());
            ArrayList<String> tags = new ArrayList<String>();
            JsonArray array = object.getAsJsonArray("tags");
            for (JsonElement tag : array) {
                tags.add(tag.getAsString());
            }
            this.tags = tags;
            this.rank = object.get("rank").getAsInt();
            this.bgColor = object.get("backgroundColor").getAsInt();
            this.minecraft = minecraft;
            this.assignCommonData();
        }

        private void assignCommonData() {
            Object ip = this.port != 0 ? this.ipAddress + ":" + this.port : this.ipAddress;
            this.icon = FaviconTexture.forServer((TextureManager)this.minecraft.getTextureManager(), (String)ip);
            this.serverData = new ServerData(this.serverName, (String)ip, ServerData.Type.OTHER);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)ServerBrowserList.this.getRowLeft();
            if (d <= 32.0 && d < 32.0 && d > 16.0 && this.canJoin()) {
                this.screen.setSelected(this);
                this.screen.joinSelectedServer();
                return true;
            }
            this.screen.setSelected(this);
            if (Util.getMillis() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = Util.getMillis();
            return false;
        }

        public Component getNarration() {
            return Component.literal((String)"howdy partner");
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.serverData.state() == ServerData.State.INITIAL) {
                this.serverData.setState(ServerData.State.PINGING);
                this.serverData.ping = -2L;
                this.serverData.motd = CommonComponents.EMPTY;
                this.serverData.status = CommonComponents.EMPTY;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().pingServer(this.serverData, () -> {
                            this.serverData.setState(this.serverData.protocol == SharedConstants.getCurrentVersion().getProtocolVersion() ? ServerData.State.SUCCESSFUL : ServerData.State.INCOMPATIBLE);
                            this.minecraft.execute(this::refreshStatus);
                        }, this.validServer);
                    }
                    catch (UnknownHostException unknownhostexception) {
                        this.serverData.setState(ServerData.State.UNREACHABLE);
                        this.serverData.motd = CANT_RESOLVE_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                        this.validServer.set(false);
                    }
                    catch (Exception exception) {
                        this.serverData.setState(ServerData.State.UNREACHABLE);
                        this.serverData.motd = CANT_CONNECT_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                        this.validServer.set(false);
                    }
                });
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().pingServer(this.serverData, () -> this.minecraft.execute(() -> {}), this.validServer);
                    }
                    catch (UnknownHostException var2) {
                        this.serverData.ping = -1L;
                        this.serverData.motd = CANT_RESOLVE_TEXT;
                        this.validServer.set(false);
                    }
                    catch (Exception var3) {
                        this.serverData.ping = -1L;
                        this.serverData.motd = CANT_CONNECT_TEXT;
                        this.validServer.set(false);
                    }
                });
            }
            if (this.validServer.get()) {
                byte[] abyte;
                if (hovering) {
                    graphics.fill(left, top, ServerBrowserList.this.getRight(), top + height + 4, -2009829869);
                }
                graphics.drawString(this.minecraft.font, this.serverData.name, left + 32 + 3, top + 1, 0xFFFFFF, false);
                List list = this.minecraft.font.split((FormattedText)this.serverData.motd, width - 32 - 2);
                for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                    graphics.drawString(this.minecraft.font, (FormattedCharSequence)list.get(i), left + 32 + 3, top + 12 + 9 * i, -8355712, false);
                }
                this.drawIcon(graphics, left, top, this.icon.textureLocation());
                if (this.serverData.state() == ServerData.State.PINGING) {
                    int j1 = (int)(Util.getMillis() / 100L + (long)(index * 2) & 7L);
                    if (j1 > 4) {
                        j1 = 8 - j1;
                    }
                    this.statusIcon = switch (j1) {
                        case 1 -> PINGING_2_SPRITE;
                        case 2 -> PINGING_3_SPRITE;
                        case 3 -> PINGING_4_SPRITE;
                        case 4 -> PINGING_5_SPRITE;
                        default -> PINGING_1_SPRITE;
                    };
                }
                int k1 = left + width - 10 - 5;
                if (this.statusIcon != null) {
                    graphics.blitSprite(this.statusIcon, k1, top, 10, 8);
                }
                if (!Arrays.equals(abyte = this.serverData.getIconBytes(), this.lastIconB64)) {
                    if (this.uploadServerIcon(abyte)) {
                        this.lastIconB64 = abyte;
                    } else {
                        this.serverData.setIconBytes(null);
                    }
                }
                Component component = this.serverData.state() == ServerData.State.INCOMPATIBLE ? this.serverData.version.copy().withStyle(ChatFormatting.RED) : this.serverData.status;
                int j = this.minecraft.font.width((FormattedText)component);
                int k = k1 - j - 5;
                graphics.drawString(this.minecraft.font, component, k, top + 1, -8355712, false);
                if (this.statusIconTooltip != null && mouseX >= k1 && mouseX <= k1 + 10 && mouseY >= top && mouseY <= top + 8) {
                    this.screen.setTooltipForNextRenderPass(this.statusIconTooltip);
                } else if (this.onlinePlayersTooltip != null && mouseX >= k && mouseX <= k + j && mouseY >= top && mouseY <= top - 1 + 9) {
                    this.screen.setTooltipForNextRenderPass(Lists.transform(this.onlinePlayersTooltip, Component::getVisualOrderText));
                }
                if (((Boolean)this.minecraft.options.touchscreen().get()).booleanValue() || hovering) {
                    graphics.fill(left, top, left + 32, top + 32, -1601138544);
                    int l = mouseX - left;
                    int i1 = mouseY - top;
                    if (this.canJoin()) {
                        if (l < 32 && l > 16) {
                            graphics.blitSprite(JOIN_HIGHLIGHTED_SPRITE, left, top, 32, 32);
                        } else {
                            graphics.blitSprite(JOIN_SPRITE, left, top, 32, 32);
                        }
                    }
                }
            } else {
                ServerBrowserList.this.removeEntry((AbstractSelectionList.Entry)this);
            }
        }

        private void refreshStatus() {
            this.onlinePlayersTooltip = null;
            switch (this.serverData.state()) {
                case INITIAL: 
                case PINGING: {
                    this.statusIcon = PING_1_SPRITE;
                    this.statusIconTooltip = PINGING_STATUS;
                    break;
                }
                case INCOMPATIBLE: {
                    this.statusIcon = INCOMPATIBLE_SPRITE;
                    this.statusIconTooltip = INCOMPATIBLE_STATUS;
                    this.onlinePlayersTooltip = this.serverData.playerList;
                    break;
                }
                case UNREACHABLE: {
                    this.statusIcon = UNREACHABLE_SPRITE;
                    this.statusIconTooltip = NO_CONNECTION_STATUS;
                    break;
                }
                case SUCCESSFUL: {
                    this.statusIcon = this.serverData.ping < 150L ? PING_5_SPRITE : (this.serverData.ping < 300L ? PING_4_SPRITE : (this.serverData.ping < 600L ? PING_3_SPRITE : (this.serverData.ping < 1000L ? PING_2_SPRITE : PING_1_SPRITE)));
                    this.statusIconTooltip = Component.translatable((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.ping});
                    this.onlinePlayersTooltip = this.serverData.playerList;
                }
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        protected void drawIcon(GuiGraphics $$0, int $$1, int $$2, ResourceLocation $$3) {
            RenderSystem.enableBlend();
            $$0.blit($$3, $$1, $$2, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        private boolean uploadServerIcon(byte[] bytes) {
            if (bytes == null) {
                this.icon.clear();
            } else {
                try {
                    this.icon.upload(NativeImage.read((byte[])bytes));
                }
                catch (Throwable var3) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.name, this.serverData.ip, var3});
                    return false;
                }
            }
            return true;
        }

        private boolean canJoin() {
            return true;
        }

        public ServerData getServerData() {
            return this.serverData;
        }
    }
}

