/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client;

import com.epherical.serverbrowser.client.extension.BccAccess;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import dev.wuffs.bcc.CommonClass;
import dev.wuffs.bcc.data.BetterStatus;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.multiplayer.LegacyServerPinger;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import org.slf4j.Logger;

public class ServerPinger {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component CANT_CONNECT_MESSAGE = Component.translatable((String)"multiplayer.status.cannot_connect").withStyle(style -> style.withColor(-65536));
    private final List<Connection> connections = Collections.synchronizedList(Lists.newArrayList());

    public void pingServer(final ServerData data, final Runnable runnable, final AtomicBoolean atomicBoolean) throws UnknownHostException {
        final ServerAddress serverAddress = ServerAddress.parseString((String)data.ip);
        Optional<InetSocketAddress> optionalINet = ServerNameResolver.DEFAULT.resolveAddress(serverAddress).map(ResolvedServerAddress::asInetSocketAddress);
        if (!optionalINet.isPresent()) {
            atomicBoolean.set(false);
            this.onPingFailed(ConnectScreen.UNKNOWN_HOST_MESSAGE, data);
        } else {
            final InetSocketAddress socketAddress = optionalINet.get();
            final Connection connection = Connection.connectToServer((InetSocketAddress)socketAddress, (boolean)false, null);
            this.connections.add(connection);
            data.motd = Component.translatable((String)"multiplayer.status.pinging");
            data.ping = -1L;
            data.playerList = Collections.emptyList();
            ClientStatusPacketListener clientstatuspacketlistener = new ClientStatusPacketListener(){
                private boolean success;
                private boolean receivedPing;
                private long pingStart;

                public void handleStatusResponse(ClientboundStatusResponsePacket packet) {
                    if (this.receivedPing) {
                        connection.disconnect((Component)Component.translatable((String)"multiplayer.status.unrequested"));
                    } else {
                        this.receivedPing = true;
                        ServerStatus serverstatus = packet.status();
                        data.motd = serverstatus.description();
                        serverstatus.version().ifPresentOrElse(version -> {
                            data2.version = Component.literal((String)version.name());
                            data2.protocol = version.protocol();
                        }, () -> {
                            data2.version = Component.translatable((String)"multiplayer.status.old");
                            data2.protocol = 0;
                        });
                        serverstatus.players().ifPresentOrElse(players -> {
                            data2.status = ServerStatusPinger.formatPlayerCount((int)players.online(), (int)players.max());
                            data2.players = players;
                            if (!players.sample().isEmpty()) {
                                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(players.sample().size());
                                for (GameProfile gameprofile : players.sample()) {
                                    list.add(Component.literal((String)gameprofile.getName()));
                                }
                                if (players.sample().size() < players.online()) {
                                    list.add(Component.translatable((String)"multiplayer.status.and_more", (Object[])new Object[]{players.online() - players.sample().size()}));
                                }
                                data2.playerList = list;
                            } else {
                                data2.playerList = List.of();
                            }
                        }, () -> {
                            data2.status = Component.translatable((String)"multiplayer.status.unknown").withStyle(ChatFormatting.DARK_GRAY);
                        });
                        serverstatus.favicon().ifPresent(fav -> {
                            if (!Arrays.equals(fav.iconBytes(), data.getIconBytes())) {
                                data.setIconBytes(ServerData.validateIcon((byte[])fav.iconBytes()));
                                runnable.run();
                            }
                        });
                        this.pingStart = Util.getMillis();
                        connection.send((Packet)new ServerboundPingRequestPacket(this.pingStart));
                        this.success = true;
                        try {
                            if (BccAccess.SERVER_DATA_EXTENSION != null && BccAccess.SERVER_DATA_EXTENSION.isInstance(packet.status()) && BccAccess.GET_BETTER_DATA != null) {
                                BetterStatus betterData = BccAccess.GET_BETTER_DATA.invoke(packet.status());
                                if (betterData == null || !CommonClass.comparePingData((BetterStatus)betterData)) {
                                    atomicBoolean.set(false);
                                }
                                if (BccAccess.SERVER_DATA_EXTENSION.isInstance(data) && BccAccess.SET_BETTER_DATA != null) {
                                    BccAccess.SET_BETTER_DATA.invoke(data, betterData);
                                }
                            }
                        }
                        catch (Throwable reflectiveFailure) {
                            LOGGER.debug("Optional BetterStatus processing failed: {}", (Object)reflectiveFailure.toString());
                        }
                    }
                }

                public void handlePongResponse(ClientboundPongResponsePacket packet) {
                    long i = this.pingStart;
                    long j = Util.getMillis();
                    data.ping = j - i;
                    connection.disconnect((Component)Component.translatable((String)"multiplayer.status.finished"));
                    runnable.run();
                }

                public void onDisconnect(DisconnectionDetails details) {
                    if (!this.success) {
                        ServerPinger.this.onPingFailed(details.reason(), data);
                        ServerPinger.this.pingLegacyServer(socketAddress, serverAddress, data);
                    }
                }

                public boolean isAcceptingMessages() {
                    return connection.isConnected();
                }
            };
            try {
                connection.initiateServerboundStatusConnection(serverAddress.getHost(), serverAddress.getPort(), clientstatuspacketlistener);
                connection.send((Packet)ServerboundStatusRequestPacket.INSTANCE);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to ping server {}", (Object)serverAddress, (Object)throwable);
            }
        }
    }

    void pingLegacyServer(InetSocketAddress resolvedServerAddress, final ServerAddress serverAddress, final ServerData serverData) {
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)Connection.NETWORK_WORKER_GROUP.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(this){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                channel.pipeline().addLast(new ChannelHandler[]{new LegacyServerPinger(serverAddress, (p_315832_, p_315833_, p_315834_, p_315835_, p_315836_) -> {
                    serverData.setState(ServerData.State.INCOMPATIBLE);
                    serverData2.version = Component.literal((String)p_315833_);
                    serverData2.motd = Component.literal((String)p_315834_);
                    serverData2.status = ServerStatusPinger.formatPlayerCount((int)p_315835_, (int)p_315836_);
                    serverData2.players = new ServerStatus.Players(p_315836_, p_315835_, List.of());
                })});
            }
        })).channel(NioSocketChannel.class)).connect(resolvedServerAddress.getAddress(), resolvedServerAddress.getPort());
    }

    static Component formatPlayerCount(int $$0, int $$1) {
        return Component.literal((String)Integer.toString($$0)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.DARK_GRAY)).append(Integer.toString($$1)).withStyle(ChatFormatting.GRAY);
    }

    public void onPingFailed(Component message, ServerData server) {
        LOGGER.error("Can't ping {}: {}", (Object)server.ip, (Object)message.getString());
        server.motd = CANT_CONNECT_MESSAGE;
        server.status = CommonComponents.EMPTY;
    }
}

