/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.integration;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.ClaimStorage;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public final class FlanCompat {
    public static boolean canBreak(@NotNull Player player, @NotNull BlockPos pos) {
        if (player.level().isClientSide) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.level()));
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)player, BuiltinPermission.BREAK, pos, true);
        }
        catch (Exception e) {
            Amendments.LOGGER.error("Failed call break block event: [Player: {}, Pos: {}]", (Object)player, (Object)pos, (Object)e);
            return true;
        }
    }

    public static boolean canPlace(@NotNull Player player, @NotNull BlockPos pos) {
        if (player.level().isClientSide) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.level()));
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)player, BuiltinPermission.PLACE, pos);
        }
        catch (Exception e) {
            Amendments.LOGGER.error("Failed call place block event: [Player: {}, Pos: {}]", (Object)player, (Object)pos, (Object)e);
            return true;
        }
    }

    public static boolean canReplace(@NotNull Player player, @NotNull BlockPos pos) {
        if (player.level().isClientSide) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.level()));
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            return claim.canInteract((ServerPlayer)player, BuiltinPermission.PLACE, pos);
        }
        catch (Exception e) {
            Amendments.LOGGER.error("Failed call replace block event: [Player: {}, Pos: {}]", (Object)player, (Object)pos, (Object)e);
            return true;
        }
    }

    public static boolean canAttack(@NotNull Player player, @NotNull Entity victim) {
        if (player.level().isClientSide) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.level()));
            IPermissionContainer claim = storage.getForPermissionCheck(victim.blockPosition());
            if (victim instanceof ServerPlayer) {
                return claim.canInteract((ServerPlayer)player, BuiltinPermission.HURTPLAYER, victim.blockPosition());
            }
            return claim.canInteract((ServerPlayer)player, BuiltinPermission.HURTANIMAL, victim.blockPosition());
        }
        catch (Exception e) {
            Supplementaries.LOGGER.error("Failed call attack entity event: [Player: {}, Victim: {}]", (Object)player, (Object)victim, (Object)e);
            return true;
        }
    }

    public static boolean canInteract(@NotNull Player player, @NotNull BlockPos targetPos) {
        if (player.level().isClientSide) {
            return true;
        }
        try {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)((ServerLevel)player.level()));
            IPermissionContainer claim = storage.getForPermissionCheck(targetPos);
            return claim.canInteract((ServerPlayer)player, BuiltinPermission.INTERACTBLOCK, targetPos);
        }
        catch (Exception e) {
            Amendments.LOGGER.error("Failed call interact event: [Player: {}, Pos: {}]", (Object)player, (Object)targetPos, (Object)e);
            return true;
        }
    }
}

