/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import net.mehvahdjukaar.amendments.common.block.CommonCauldronCode;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.AlexCavesCompat;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquidCauldronBlock
extends ModCauldronBlock {
    public static final MapCodec<LiquidCauldronBlock> CODEC = LiquidCauldronBlock.simpleCodec(LiquidCauldronBlock::new);
    public static final IntegerProperty LEVEL = PlatHelper.getPlatform().isFabric() ? BlockStateProperties.LEVEL_CAULDRON : ModBlockProperties.LEVEL_1_4;
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;

    public LiquidCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(value -> (Integer)value.getValue((Property)LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LEVEL, (Comparable)Integer.valueOf(1))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)BOILING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends LiquidCauldronBlock> codec() {
        return CODEC;
    }

    @Override
    public IntegerProperty getLevelProperty() {
        return LEVEL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEVEL, LIGHT_LEVEL});
    }

    protected boolean canReceiveStalactiteDrip(Fluid fluid) {
        return true;
    }

    public void receiveStalactiteDrip(BlockState state, Level level, BlockPos pos, Fluid fluid) {
        BlockEntity blockEntity;
        if (!this.isFull(state) && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile) {
            SoftFluidStack sf;
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            int amount = SoftFluid.BOTTLE_COUNT;
            if (!CommonConfigs.LAVA_LAYERS.get().booleanValue() && fluid == Fluids.LAVA) {
                amount = SoftFluid.BUCKET_COUNT;
            }
            if (!(sf = SoftFluidStack.fromFluid((Fluid)fluid, (int)amount, (DataComponentPatch)DataComponentPatch.EMPTY, (HolderLookup.Provider)level.registryAccess())).isEmpty() && te.getSoftFluidTank().addFluid(sf, false) != 0) {
                te.setChanged();
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
                if (fluid == Fluids.LAVA) {
                    level.levelEvent(1046, pos, 0);
                } else {
                    level.levelEvent(1047, pos, 0);
                }
            }
        }
    }

    @Override
    public void handlePrecipitation(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        BlockEntity blockEntity;
        super.handlePrecipitation(state, level, pos, precipitation);
        if (!this.isFull(state) && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidTank softFluidTank = te.getSoftFluidTank();
            SoftFluidStack sf = softFluidTank.getFluid();
            if (precipitation == Biome.Precipitation.RAIN && sf.is(MLBuiltinSoftFluids.WATER) && softFluidTank.addFluid(SoftFluidStack.fromFluid((Fluid)Fluids.WATER, (int)1, (DataComponentPatch)DataComponentPatch.EMPTY, (HolderLookup.Provider)level.registryAccess()), false) > 0) {
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
                te.setChanged();
            }
        }
    }

    @Override
    protected void handleEntityInsideFluidSpecial(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        if (entity.mayInteract(level, pos) && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile) {
            ItemEntity ie;
            LiquidCauldronBlockTile tile = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidStack fluid = tile.getSoftFluidTank().getFluid();
            PotionBottleType potType = this.getPotType(fluid);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (potType != null && potType != PotionBottleType.REGULAR && this.applyPotionFluidEffects(level, pos, living, fluid)) {
                    tile.consumeOneLayer();
                    level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidDamage(fluid, level, pos, state, entity);
                }
            }
            if (!tile.isGlowing() && fluid.is(ModTags.CAN_GLOW) && entity instanceof ItemEntity && (ie = (ItemEntity)entity).getItem().is(Items.GLOW_INK_SAC) && this.isEntityInsideContent(state, pos, entity)) {
                CommonCauldronCode.playSplashEffects(entity, this.getContentHeight(state));
                tile.setGlowing(true);
                level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
                ie.getItem().shrink(1);
                if (ie.getItem().isEmpty()) {
                    ie.discard();
                }
            }
        }
    }

    private boolean applyPotionFluidEffects(Level level, BlockPos pos, LivingEntity living, SoftFluidStack stack) {
        List<MobEffectInstance> effects = this.getPotionEffects(stack);
        boolean success = false;
        for (MobEffectInstance effect : effects) {
            Holder ef = effect.getEffect();
            if (living.hasEffect(ef)) continue;
            if (((MobEffect)ef.value()).isInstantenous()) {
                ((MobEffect)ef.value()).applyInstantenousEffect(null, null, living, effect.getAmplifier(), 1.0);
            } else {
                living.addEffect(new MobEffectInstance(effect));
            }
            success = true;
        }
        if (success) {
            level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return success;
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.animateTick(state, level, pos, rand);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidTank tank = te.getSoftFluidTank();
            if (level.random.nextInt(4) == 0) {
                SoftFluidStack fluid = tank.getFluid();
                PotionBottleType type = this.getPotType(fluid);
                double height = this.getContentHeight(state);
                if (type != null) {
                    if (LiquidCauldronBlock.getAllPotionEffects(fluid).size() >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
                        CommonCauldronCode.addSurfaceParticles((ParticleOptions)ParticleTypes.SMOKE, level, pos, 2, height, rand, 0.0f, 0.0f, 0.0f);
                    }
                    if (type != PotionBottleType.REGULAR) {
                        int color = tank.getCachedParticleColor((BlockAndTintGetter)level, pos);
                        int alpha = type == PotionBottleType.SPLASH ? Mth.floor((float)38.25f) : 255;
                        ColorParticleOption particle = ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)alpha, (int)color));
                        this.addPotionParticles((ParticleOptions)particle, level, pos, 1, height, rand, color);
                    }
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidParticles(fluid, level, pos, rand, height);
                }
                BlockPos blockPos = pos.above();
                if (fluid.is(MLBuiltinSoftFluids.LAVA) && level.getBlockState(blockPos).isAir() && !level.getBlockState(blockPos).isSolidRender((BlockGetter)level, blockPos)) {
                    Vec3 c = pos.getCenter();
                    if (rand.nextInt(20) == 0) {
                        CommonCauldronCode.addSurfaceParticles((ParticleOptions)ParticleTypes.LAVA, level, pos, 1, height, rand, 0.0f, 0.0f, 0.0f);
                        level.playLocalSound(c.x, height, c.z, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                    }
                    if (rand.nextInt(40) == 0) {
                        level.playLocalSound(c.x, height, c.z, SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                    }
                }
            }
        }
    }

    @NotNull
    public static ArrayList<MobEffectInstance> getAllPotionEffects(SoftFluidStack fluid) {
        return Lists.newArrayList((Iterable)((PotionContents)fluid.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getAllEffects());
    }

    @Nullable
    private PotionBottleType getPotType(SoftFluidStack stack) {
        if (stack.is(MLBuiltinSoftFluids.POTION)) {
            return (PotionBottleType)stack.getOrDefault((DataComponentType)MoonlightRegistry.BOTTLE_TYPE.get(), (Object)PotionBottleType.REGULAR);
        }
        return null;
    }

    private List<MobEffectInstance> getPotionEffects(SoftFluidStack stack) {
        return StreamSupport.stream(((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getAllEffects().spliterator(), false).toList();
    }

    private void addPotionParticles(ParticleOptions type, Level level, BlockPos pos, int count, double surface, RandomSource rand, int color) {
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        CommonCauldronCode.addSurfaceParticles(type, level, pos, count, surface, rand, r, g, b);
    }

    @Override
    public BlockState updateStateOnFluidChange(BlockState state, Level level, BlockPos pos, SoftFluidStack fluid) {
        BlockState exploded = this.maybeExplode(state, level, pos, fluid);
        if (exploded != null) {
            return exploded;
        }
        int light = fluid.fluid().getLuminosity();
        if (light != (Integer)state.getValue((Property)ModBlockProperties.LIGHT_LEVEL)) {
            state = (BlockState)state.setValue((Property)ModBlockProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(light));
        }
        return super.updateStateOnFluidChange(state, level, pos, fluid);
    }

    @Nullable
    private BlockState maybeExplode(BlockState state, Level level, BlockPos pos, SoftFluidStack fluid) {
        ArrayList<MobEffectInstance> potionEffects = LiquidCauldronBlock.getAllPotionEffects(fluid);
        int potionEffectAmount = potionEffects.size();
        if (potionEffectAmount >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
            if (potionEffectAmount > CommonConfigs.POTION_MIXING_LIMIT.get()) {
                level.destroyBlock(pos, true);
                Vec3 vec3 = pos.getCenter();
                level.explode(null, level.damageSources().badRespawnPointExplosion(vec3), null, vec3.x, vec3.y, vec3.z, 1.4f, false, Level.ExplosionInteraction.NONE);
                return state;
            }
            if (level.isClientSide) {
                CommonCauldronCode.addSurfaceParticles((ParticleOptions)ParticleTypes.SMOKE, level, pos, 12, this.getContentHeight(state), level.random, 0.0f, 0.0f, 0.0f);
            }
            level.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return null;
        }
        Map<MobEffect, MobEffect> inverse = CommonConfigs.INVERSE_POTIONS.get();
        List<MobEffect> effects = potionEffects.stream().map(e -> (MobEffect)e.getEffect().value()).toList();
        for (MobEffect effect : effects) {
            MobEffect inv = inverse.get(effect);
            if (inv == null || !effects.contains(inv)) continue;
            if (level.isClientSide) {
                CommonCauldronCode.addSurfaceParticles((ParticleOptions)ParticleTypes.POOF, level, pos, 8, this.getContentHeight(state), level.random, 0.0f, 0.01f + level.random.nextFloat() * 0.1f, 0.0f);
            }
            level.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return Blocks.CAULDRON.defaultBlockState();
        }
        return null;
    }
}

