/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@Beta
public final class ItemSprites {
    private final ImmutableMap<Integer, ResourceLocation> map;

    private ItemSprites(@Nullable ResourceLocation enabled, @Nullable ResourceLocation disabled, @Nullable ResourceLocation enabledHovered, @Nullable ResourceLocation disabledHovered, @Nullable ResourceLocation enabledSelected, @Nullable ResourceLocation disabledSelected, @Nullable ResourceLocation enabledHoveredSelected, @Nullable ResourceLocation disabledHoveredSelected) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (disabled != null) {
            builder.put((Object)this.calculateKey(false, false, false), (Object)disabled);
        }
        if (enabled != null) {
            builder.put((Object)this.calculateKey(true, false, false), (Object)enabled);
        }
        if (disabledHovered != null) {
            builder.put((Object)this.calculateKey(false, true, false), (Object)disabledHovered);
        }
        if (enabledHovered != null) {
            builder.put((Object)this.calculateKey(true, true, false), (Object)enabledHovered);
        }
        if (disabledSelected != null) {
            builder.put((Object)this.calculateKey(false, false, true), (Object)disabledSelected);
        }
        if (enabledSelected != null) {
            builder.put((Object)this.calculateKey(true, false, true), (Object)enabledSelected);
        }
        if (disabledHoveredSelected != null) {
            builder.put((Object)this.calculateKey(false, true, true), (Object)disabledHoveredSelected);
        }
        if (enabledHoveredSelected != null) {
            builder.put((Object)this.calculateKey(true, true, true), (Object)enabledHoveredSelected);
        }
        this.map = builder.build();
    }

    private int calculateKey(boolean enabled, boolean hovered, boolean selected) {
        int key = 0;
        if (enabled) {
            key |= 1;
        }
        if (hovered) {
            key |= 2;
        }
        if (selected) {
            key |= 4;
        }
        return key;
    }

    public ResourceLocation getSprite(boolean enabled, boolean hovered, boolean selected) {
        return (ResourceLocation)this.map.get((Object)this.calculateKey(enabled, hovered, selected));
    }

    public static ItemSprites of(@Nullable ResourceLocation all) {
        return new ItemSprites(all, all, all, all, all, all, all, all);
    }

    public static ItemSprites of(@Nullable ResourceLocation enabled, @Nullable ResourceLocation disabled, @Nullable ResourceLocation enabledSelected) {
        return new ItemSprites(enabled, disabled, enabled, disabled, enabledSelected, disabled, enabledSelected, disabled);
    }

    public static ItemSprites of(@Nullable ResourceLocation enabled, @Nullable ResourceLocation disabled, @Nullable ResourceLocation enabledHovered, @Nullable ResourceLocation disabledHovered, @Nullable ResourceLocation enabledSelected, @Nullable ResourceLocation disabledSelected, @Nullable ResourceLocation enabledHoveredSelected, @Nullable ResourceLocation disabledHoveredSelected) {
        return new ItemSprites(enabled, disabled, enabledHovered, disabledHovered, enabledSelected, disabledSelected, enabledHoveredSelected, disabledHoveredSelected);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private ResourceLocation enabled;
        @Nullable
        private ResourceLocation disabled;
        @Nullable
        private ResourceLocation enabledHovered;
        @Nullable
        private ResourceLocation disabledHovered;
        @Nullable
        private ResourceLocation enabledSelected;
        @Nullable
        private ResourceLocation disabledSelected;
        @Nullable
        private ResourceLocation enabledHoveredSelected;
        @Nullable
        private ResourceLocation disabledHoveredSelected;

        public ItemSprites build() {
            return new ItemSprites(this.enabled, this.disabled, this.enabledHovered, this.disabledHovered, this.enabledSelected, this.disabledSelected, this.enabledHoveredSelected, this.disabledHoveredSelected);
        }

        public Builder setEnabled(@Nullable ResourceLocation enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setDisabled(@Nullable ResourceLocation disabled) {
            this.disabled = disabled;
            return this;
        }

        public Builder setEnabledHovered(@Nullable ResourceLocation enabledHovered) {
            this.enabledHovered = enabledHovered;
            return this;
        }

        public Builder setDisabledHovered(@Nullable ResourceLocation disabledHovered) {
            this.disabledHovered = disabledHovered;
            return this;
        }

        public Builder setEnabledSelected(@Nullable ResourceLocation enabledSelected) {
            this.enabledSelected = enabledSelected;
            return this;
        }

        public Builder setDisabledSelected(@Nullable ResourceLocation disabledSelected) {
            this.disabledSelected = disabledSelected;
            return this;
        }

        public Builder setEnabledHoveredSelected(@Nullable ResourceLocation enabledHoveredSelected) {
            this.enabledHoveredSelected = enabledHoveredSelected;
            return this;
        }

        public Builder setDisabledHoveredSelected(@Nullable ResourceLocation disabledHoveredSelected) {
            this.disabledHoveredSelected = disabledHoveredSelected;
            return this;
        }
    }
}

