/*
 * Decompiled with CFR 0.152.
 */
package fuzs.dyedflames.neoforge.data;

import fuzs.dyedflames.init.ModRegistry;
import fuzs.dyedflames.world.level.block.FireType;
import fuzs.neoforgedatapackextensions.neoforge.api.v1.NeoForgeDataMapToken;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;

public class ModDataMapProvider
extends DataMapProvider {
    public ModDataMapProvider(DataProviderContext context) {
        this(context.getPackOutput(), context.getRegistries());
    }

    public ModDataMapProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void gather() {
        DataMapProvider.Builder builder = this.builder(NeoForgeDataMapToken.unwrap(ModRegistry.FIRE_TYPES_DATA_MAP_TYPE));
        ModDataMapProvider.register((DataMapProvider.Builder<FireType, Block>)builder, Blocks.FIRE, ResourceLocationHelper.withDefaultNamespace((String)"block/fire_0"), ResourceLocationHelper.withDefaultNamespace((String)"block/fire_1"), ParticleTypes.LAVA);
        ModDataMapProvider.register((DataMapProvider.Builder<FireType, Block>)builder, Blocks.LAVA, Optional.of(FluidTags.LAVA), ResourceLocationHelper.withDefaultNamespace((String)"block/fire_0"), ResourceLocationHelper.withDefaultNamespace((String)"block/fire_1"), ParticleTypes.LAVA);
        ModDataMapProvider.register((DataMapProvider.Builder<FireType, Block>)builder, Blocks.SOUL_FIRE, ResourceLocationHelper.withDefaultNamespace((String)"block/soul_fire_0"), ResourceLocationHelper.withDefaultNamespace((String)"block/soul_fire_1"), (SimpleParticleType)ModRegistry.SOUL_LAVA_PARTICLE_TYPE.value());
    }

    static void register(DataMapProvider.Builder<FireType, Block> builder, Block block, ResourceLocation texture0, ResourceLocation texture1, SimpleParticleType particleType) {
        ModDataMapProvider.register(builder, block, Optional.empty(), texture0, texture1, particleType);
    }

    static void register(DataMapProvider.Builder<FireType, Block> builder, Block block, Optional<TagKey<Fluid>> fluids, ResourceLocation texture0, ResourceLocation texture1, SimpleParticleType particleType) {
        builder.add((Holder)block.builtInRegistryHolder(), (Object)new FireType(fluids, texture0, texture1, Optional.of(particleType)), false, new ICondition[0]);
    }
}

