/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.layer;

import mod.azure.azurelib.common.cache.texture.AzAbstractTexture;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzRendererConfig;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.layer.AzRenderLayer;
import mod.azure.azurelib.common.util.client.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AzAutoGlowingLayer<K, T>
implements AzRenderLayer<K, T> {
    @Override
    public void preRender(AzRendererPipelineContext<K, T> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<K, T> context) {
        AzRendererPipeline<K, T> renderPipeline = context.rendererPipeline();
        RenderType renderType = this.determineRenderType(context);
        if (renderType != null) {
            context.setRenderType(renderType);
            context.setPackedLight(this.getPackedLight(context));
            context.setVertexConsumer(context.multiBufferSource().getBuffer(renderType));
            renderPipeline.reRender(context);
        }
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<K, T> context, AzBone bone) {
    }

    protected int getPackedLight(AzRendererPipelineContext<K, T> context) {
        return 0xF00000;
    }

    protected RenderType determineRenderType(AzRendererPipelineContext<K, T> context) {
        T animatable = context.animatable();
        AzRendererConfig<K, T> config = context.rendererPipeline().config();
        ResourceLocation textureLocation = config.textureLocation(context.currentEntity(), animatable);
        if (!(animatable instanceof Entity)) {
            return AzAbstractTexture.getRenderType(textureLocation);
        }
        Entity entity = (Entity)animatable;
        boolean isInvisible = entity.isInvisible();
        boolean appearsGlowing = Minecraft.getInstance().shouldEntityAppearGlowing(entity);
        boolean isPlayerInvisible = entity.isInvisibleTo(ClientUtils.getClientPlayer());
        if (isInvisible) {
            if (!isPlayerInvisible) {
                return RenderType.itemEntityTranslucentCull((ResourceLocation)AzAbstractTexture.getEmissiveResource(textureLocation));
            }
            if (appearsGlowing) {
                return RenderType.outline((ResourceLocation)AzAbstractTexture.getEmissiveResource(textureLocation));
            }
            return null;
        }
        if (appearsGlowing) {
            return AzAbstractTexture.getOutlineRenderType(textureLocation);
        }
        return AzAbstractTexture.getRenderType(textureLocation);
    }
}

