/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzModelRenderer;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.item.AzItemRendererPipelineContext;
import mod.azure.azurelib.common.util.client.ClientUtils;
import mod.azure.azurelib.common.util.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class AzItemArmRenderUtil {
    private static final String LEFT_ARM_BONE = "leftArm";
    private static final String RIGHT_ARM_BONE = "rightArm";

    public static boolean isArmBone(AzBone bone) {
        String name = bone.getName();
        return LEFT_ARM_BONE.equals(name) || RIGHT_ARM_BONE.equals(name);
    }

    public static boolean shouldRenderArmsForContext(AzItemRendererPipelineContext context) {
        ItemDisplayContext transformType = context.getTransformType();
        return transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
    }

    public static void renderArmForBone(AzRendererPipelineContext<UUID, ItemStack> context, AzBone bone, AzModelRenderer<UUID, ItemStack> modelRenderer) {
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        if (!AzItemArmRenderUtil.shouldRenderArmsForContext(itemContext)) {
            return;
        }
        bone.setHidden(true);
        bone.setChildrenHidden(false);
        Minecraft client = Minecraft.getInstance();
        PoseStack poseStack = context.poseStack();
        int packedLight = context.packedLight();
        PlayerRenderer playerEntityRenderer = (PlayerRenderer)client.getEntityRenderDispatcher().getRenderer((Entity)client.player);
        PlayerModel playerEntityModel = (PlayerModel)playerEntityRenderer.getModel();
        ResourceLocation playerSkin = ((LocalPlayer)ClientUtils.getClientPlayer()).getSkin().texture();
        poseStack.pushPose();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        if (LEFT_ARM_BONE.equals(bone.getName())) {
            AzItemArmRenderUtil.renderLeftArm(poseStack, bone, playerEntityModel, playerSkin, packedLight, itemContext, modelRenderer);
        } else if (RIGHT_ARM_BONE.equals(bone.getName())) {
            AzItemArmRenderUtil.renderRightArm(poseStack, bone, playerEntityModel, playerSkin, packedLight, itemContext, modelRenderer);
        }
        poseStack.popPose();
    }

    private static void renderLeftArm(PoseStack poseStack, AzBone bone, PlayerModel<?> playerEntityModel, ResourceLocation playerSkin, int packedLight, AzItemRendererPipelineContext itemContext, AzModelRenderer<UUID, ItemStack> modelRenderer) {
        poseStack.scale(0.67f, 1.33f, 0.67f);
        poseStack.translate(-0.25, -0.43625, 0.1625);
        playerEntityModel.leftArm.setPos(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        playerEntityModel.leftArm.setRotation(0.0f, 0.0f, 0.0f);
        playerEntityModel.leftArm.render(poseStack, modelRenderer.getOrRefreshBufferRenderType(itemContext, bone, RenderType.entitySolid((ResourceLocation)playerSkin)), packedLight, OverlayTexture.NO_OVERLAY);
        playerEntityModel.leftSleeve.setPos(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        playerEntityModel.leftSleeve.setRotation(0.0f, 0.0f, 0.0f);
        playerEntityModel.leftSleeve.render(poseStack, modelRenderer.getOrRefreshBufferRenderType(itemContext, bone, RenderType.entityTranslucent((ResourceLocation)playerSkin)), packedLight, OverlayTexture.NO_OVERLAY);
    }

    private static void renderRightArm(PoseStack poseStack, AzBone bone, PlayerModel<?> playerEntityModel, ResourceLocation playerSkin, int packedLight, AzItemRendererPipelineContext itemContext, AzModelRenderer<UUID, ItemStack> modelRenderer) {
        poseStack.scale(0.67f, 1.33f, 0.67f);
        poseStack.translate(0.25, -0.43625, 0.1625);
        playerEntityModel.rightArm.setPos(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        playerEntityModel.rightArm.setRotation(0.0f, 0.0f, 0.0f);
        playerEntityModel.rightArm.render(poseStack, modelRenderer.getOrRefreshBufferRenderType(itemContext, bone, RenderType.entitySolid((ResourceLocation)playerSkin)), packedLight, OverlayTexture.NO_OVERLAY);
        playerEntityModel.rightSleeve.setPos(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
        playerEntityModel.rightSleeve.setRotation(0.0f, 0.0f, 0.0f);
        playerEntityModel.rightSleeve.render(poseStack, modelRenderer.getOrRefreshBufferRenderType(itemContext, bone, RenderType.entityTranslucent((ResourceLocation)playerSkin)), packedLight, OverlayTexture.NO_OVERLAY);
    }
}

