/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.model.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.common.cache.AzResourceCache;
import mod.azure.azurelib.common.loading.FileLoader;
import mod.azure.azurelib.common.loading.json.raw.Model;
import mod.azure.azurelib.common.loading.object.GeometryTree;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.model.factory.registry.AzBakedModelFactoryRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class AzBakedModelCache
extends AzResourceCache {
    private static final AzBakedModelCache INSTANCE = new AzBakedModelCache();
    private final Map<ResourceLocation, AzBakedModel> bakedModels = new Object2ObjectOpenHashMap();

    public static AzBakedModelCache getInstance() {
        return INSTANCE;
    }

    private AzBakedModelCache() {
    }

    public CompletableFuture<Void> loadModels(Executor backgroundExecutor, ResourceManager resourceManager) {
        return this.loadResources(backgroundExecutor, resourceManager, "geo", resource -> {
            Model model = FileLoader.loadModelFile(resource, resourceManager);
            if (model == null) {
                ResourceLocation defaultModelLocation = AzureLib.modResource("geo/default_model.geo.json");
                model = FileLoader.loadModelFile(defaultModelLocation, resourceManager);
                AzBakedModel defaultBaked = AzBakedModelFactoryRegistry.getForNamespace(resource.getNamespace()).constructGeoModel(GeometryTree.fromModel(model));
                AzBakedModel.setDefault(defaultBaked);
            }
            return AzBakedModelFactoryRegistry.getForNamespace(resource.getNamespace()).constructGeoModel(GeometryTree.fromModel(model));
        }, this.bakedModels::put);
    }

    @Nullable
    public AzBakedModel getNullable(ResourceLocation resourceLocation) {
        return this.bakedModels.get(resourceLocation);
    }
}

