/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.config.client.widget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerWidget
extends AbstractWidget
implements ContainerEventHandler {
    private final List<GuiEventListener> listeners = new ArrayList<GuiEventListener>();
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    private GuiEventListener focused;
    private boolean dragging;

    public ContainerWidget(int x, int y, int w, int h, Component component) {
        super(x, y, w, h, component);
    }

    public <L extends GuiEventListener> L addGuiEventListener(L listener) {
        this.listeners.add(listener);
        return listener;
    }

    public void removeGuiEventListener(GuiEventListener listener) {
        this.listeners.remove(listener);
    }

    public <W extends AbstractWidget> W addRenderableWidget(W widget) {
        this.widgets.add(widget);
        return this.addGuiEventListener((GuiEventListener)widget);
    }

    public void removeWidget(AbstractWidget widget) {
        this.widgets.remove(widget);
        this.removeGuiEventListener((GuiEventListener)widget);
    }

    public void clear() {
        this.listeners.clear();
        this.widgets.clear();
        this.focused = null;
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.widgets.forEach(widget -> widget.render(graphics, mouseX, mouseY, partialTicks));
    }

    public boolean mouseClicked(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        boolean result = super.mouseClicked(p_231044_1_, p_231044_3_, p_231044_5_);
        if (!result && this.focused != null) {
            this.setFocused(null);
        }
        return result;
    }

    public boolean mouseReleased(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
        return super.mouseReleased(p_231048_1_, p_231048_3_, p_231048_5_);
    }

    public boolean mouseDragged(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        return super.mouseDragged(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
    }

    public boolean mouseScrolled(double p_231043_1_, double p_231043_3_, double p_231043_5_, double g) {
        return super.mouseScrolled(p_231043_1_, p_231043_3_, p_231043_5_, g);
    }

    public void mouseMoved(double p_212927_1_, double p_212927_3_) {
        super.mouseMoved(p_212927_1_, p_212927_3_);
    }

    public boolean keyPressed(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        return super.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public boolean keyReleased(int p_223281_1_, int p_223281_2_, int p_223281_3_) {
        return super.keyReleased(p_223281_1_, p_223281_2_, p_223281_3_);
    }

    public List<? extends GuiEventListener> children() {
        return this.listeners;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(GuiEventListener focused) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (focused != null) {
            focused.setFocused(true);
        }
        this.focused = focused;
    }
}

