/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.easing;

import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.Objects;
import mod.azure.azurelib.common.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelib.common.animation.easing.AzEasingTypeRegistry;
import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.core.utils.Interpolations;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public interface AzEasingType {
    public static final StreamCodec<FriendlyByteBuf, AzEasingType> STREAM_CODEC = StreamCodec.of((buf, val) -> buf.writeUtf(val.name()), buf -> Objects.requireNonNull(AzEasingTypeRegistry.getOrNull(buf.readUtf())));

    public String name();

    public Double2DoubleFunction buildTransformer(Double var1);

    default public double apply(AzAnimationPoint animationPoint) {
        Double easingVariable = null;
        if (animationPoint.keyframe() != null && animationPoint.keyframe().easingArgs().size() > 0) {
            easingVariable = ((IValue)animationPoint.keyframe().easingArgs().get(0)).get();
        }
        return this.apply(animationPoint, easingVariable, animationPoint.currentTick() / animationPoint.transitionLength());
    }

    default public double apply(AzAnimationPoint animationPoint, Double easingValue, double lerpValue) {
        if (animationPoint.currentTick() >= animationPoint.transitionLength()) {
            return (float)animationPoint.animationEndValue();
        }
        return Interpolations.lerp(animationPoint.animationStartValue(), animationPoint.animationEndValue(), (Double)this.buildTransformer(easingValue).apply((Object)lerpValue));
    }
}

