/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.controller.state.machine;

import mod.azure.azurelib.common.animation.AzAnimationContext;
import mod.azure.azurelib.common.animation.controller.AzAnimationController;
import mod.azure.azurelib.common.animation.controller.state.AzAnimationState;
import mod.azure.azurelib.common.animation.controller.state.impl.AzAnimationPauseState;
import mod.azure.azurelib.common.animation.controller.state.impl.AzAnimationPlayState;
import mod.azure.azurelib.common.animation.controller.state.impl.AzAnimationStopState;
import mod.azure.azurelib.common.animation.controller.state.impl.AzAnimationTransitionState;
import mod.azure.azurelib.common.util.state.StateMachine;
import mod.azure.azurelib.common.util.state.StateMachineContext;

public class AzAnimationControllerStateMachine<T>
extends StateMachine<Context<T>, AzAnimationState<T>> {
    private final StateHolder<T> stateHolder;

    public AzAnimationControllerStateMachine(StateHolder<T> stateHolder, AzAnimationController<T> animationController, AzAnimationContext<T> animationContext) {
        super(stateHolder.stopState());
        this.stateHolder = stateHolder;
        ((Context)this.getContext()).stateMachine = this;
        ((Context)this.getContext()).animationController = animationController;
        ((Context)this.getContext()).animationContext = animationContext;
    }

    @Override
    public Context<T> createContext() {
        return new Context();
    }

    public void initializeContext(AzAnimationController<T> controller, AzAnimationContext<T> animContext) {
        Context ctx = (Context)this.getContext();
        ctx.animationController = controller;
        ctx.animationContext = animContext;
        ctx.stateMachine = this;
    }

    public void update() {
        super.update((Context)this.getContext());
    }

    public void pause() {
        this.setState(this.stateHolder.pauseState);
    }

    public void play() {
        this.setState(this.stateHolder.playState);
    }

    public void transition() {
        this.setState(this.stateHolder.transitionState);
    }

    public void stop() {
        this.setState(this.stateHolder.stopState);
    }

    public boolean isPlaying() {
        return this.getState() == this.stateHolder.playState;
    }

    public boolean isPaused() {
        return this.getState() == this.stateHolder.pauseState;
    }

    public boolean isStopped() {
        return this.getState() == this.stateHolder.stopState;
    }

    public boolean isTransitioning() {
        return this.getState() == this.stateHolder.transitionState;
    }

    public record StateHolder<T>(AzAnimationPlayState<T> playState, AzAnimationPauseState<T> pauseState, AzAnimationStopState<T> stopState, AzAnimationTransitionState<T> transitionState) {
    }

    public static class Context<T>
    implements StateMachineContext {
        private AzAnimationContext<T> animationContext;
        private AzAnimationController<T> animationController;
        private AzAnimationControllerStateMachine<T> stateMachine;

        private Context() {
        }

        public AzAnimationContext<T> animationContext() {
            return this.animationContext;
        }

        public AzAnimationController<T> animationController() {
            return this.animationController;
        }

        public AzAnimationControllerStateMachine<T> stateMachine() {
            return this.stateMachine;
        }
    }
}

