/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib;

import mod.azure.azurelib.common.config.Config;
import mod.azure.azurelib.common.config.ConfigHolder;
import mod.azure.azurelib.common.config.ConfigHolderRegistry;
import mod.azure.azurelib.common.config.TestingConfig;
import mod.azure.azurelib.common.config.format.IConfigFormatHandler;
import mod.azure.azurelib.common.config.io.ConfigIO;
import mod.azure.azurelib.common.registry.AzureBlocksEntityRegistry;
import mod.azure.azurelib.common.registry.AzureBlocksRegistry;

public final class AzureLibMod {
    public static TestingConfig config;

    private AzureLibMod() {
        throw new UnsupportedOperationException();
    }

    public static void initRegistry() {
        AzureBlocksRegistry.init();
        AzureBlocksEntityRegistry.init();
    }

    public static <C> ConfigHolder<C> registerConfig(Class<C> configClass, IConfigFormatHandler formatFactory) {
        String group;
        Config config = configClass.getAnnotation(Config.class);
        if (config == null) {
            throw new IllegalArgumentException("Config class must be annotated with '@Config' annotation");
        }
        String id = config.id();
        String filename = config.filename();
        if (filename.isEmpty()) {
            filename = id;
        }
        if ((group = config.group()).isEmpty()) {
            group = id;
        }
        ConfigHolder<C> holder = new ConfigHolder<C>(configClass, id, filename, group, formatFactory);
        ConfigHolderRegistry.registerConfig(holder);
        if (configClass.getAnnotation(Config.NoAutoSync.class) == null) {
            ConfigIO.FILE_WATCH_MANAGER.addTrackedConfig(holder);
        }
        return holder;
    }
}

