/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import fuzs.magnumtorch.config.MobCategoryGroup;
import fuzs.magnumtorch.config.ShapeType;
import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;

public class ServerConfig
implements ConfigCore {
    @Config(name="diamond_torch")
    public final MagnumTorchConfig diamond = new MagnumTorchConfig();
    @Config(name="emerald_torch")
    public final MagnumTorchConfig emerald = new MagnumTorchConfig();
    @Config(name="amethyst_torch")
    public final MagnumTorchConfig amethyst = new MagnumTorchConfig();

    public ServerConfig() {
        this.diamond.blockedMobCategoriesConfig.monster = true;
        this.diamond.horizontalChunkRange = 4;
        this.diamond.verticalChunkRange = 2;
        this.diamond.blockedSpawnReasonsConfig.natural = true;
        this.diamond.blockedSpawnReasonsConfig.patrol = true;
        this.diamond.blockedSpawnReasonsConfig.structure = true;
        this.emerald.blockedMobCategoriesConfig.creature = true;
        this.emerald.shapeType = ShapeType.CUBOID;
        this.emerald.horizontalChunkRange = 8;
        this.emerald.verticalChunkRange = 4;
        this.emerald.blockedSpawnReasonsConfig.natural = true;
        this.emerald.blockedSpawnReasonsConfig.event = true;
        this.amethyst.blockedMobCategoriesConfig.aquatic = true;
        this.amethyst.horizontalChunkRange = 4;
        this.amethyst.verticalChunkRange = 2;
        this.amethyst.blockedSpawnReasonsConfig.natural = true;
    }

    public static class MagnumTorchConfig
    implements ConfigCore {
        @Config(name="blocked_mob_categories", description={"Mobs of this category are prevented from spawning through natural means (meaning mob spawners and breeding will still work).", "For refining affected mobs use blacklist and whitelist options.", "If you only want to prevent a few specific mobs from spawning leave all these disabled and include them in the blacklist option."})
        final BlockedMobCategoriesConfig blockedMobCategoriesConfig = new BlockedMobCategoriesConfig();
        @Config(name="mob_blacklist", description={"Mobs that should not be allowed to spawn despite being absent from \"mob_category\".", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."})
        List<String> mobBlacklistRaw = KeyedValueProvider.toString((ResourceKey)Registries.ENTITY_TYPE, (Object[])new EntityType[0]);
        @Config(name="mob_whitelist", description={"Mobs that should still be allowed to spawn despite being included in \"mob_category\".", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."})
        List<String> mobWhitelistRaw = KeyedValueProvider.toString((ResourceKey)Registries.ENTITY_TYPE, (Object[])new EntityType[0]);
        @Config(description={"Type of shape used for calculating area in which spawns are prevented.", "This basically let's you choose between maximum or euclidean metrics."})
        public ShapeType shapeType = ShapeType.ELLIPSOID;
        @Config(description={"Range in chunk sections (16x16x16 blocks) for preventing mob spawns on x-z-plane."})
        @Config.IntRange(min=1, max=16)
        int horizontalChunkRange;
        @Config(description={"Range in chunk sections (16x16x16 blocks) for preventing mob spawns on y-dimension."})
        @Config.IntRange(min=1, max=16)
        int verticalChunkRange;
        @Config(name="blocked_spawn_reasons", description={"Types of mob spawns to block.", "By default this is configured to only affect natural spawns occurring without player interaction and to not disrupt any game events."})
        final BlockedSpawnReasonsConfig blockedSpawnReasonsConfig = new BlockedSpawnReasonsConfig();
        public Set<MobCategoryGroup> blockedMobCategoryGroups;
        public Set<MobCategory> blockedMobCategories;
        public Set<MobSpawnType> blockedSpawnReasons;
        public ConfigDataSet<EntityType<?>> mobBlacklist;
        public ConfigDataSet<EntityType<?>> mobWhitelist;

        public void afterConfigReload() {
            this.blockedMobCategoryGroups = this.blockedMobCategoriesConfig.toGroupSet();
            this.blockedMobCategories = this.blockedMobCategoriesConfig.toValueSet();
            this.blockedSpawnReasons = this.blockedSpawnReasonsConfig.toSet();
            this.mobBlacklist = ConfigDataSet.from((ResourceKey)Registries.ENTITY_TYPE, this.mobBlacklistRaw, (Class[])new Class[0]);
            this.mobWhitelist = ConfigDataSet.from((ResourceKey)Registries.ENTITY_TYPE, this.mobWhitelistRaw, (Class[])new Class[0]);
        }

        public int horizontalRange() {
            return SectionPos.sectionToBlockCoord((int)this.horizontalChunkRange);
        }

        public int verticalRange() {
            return SectionPos.sectionToBlockCoord((int)this.verticalChunkRange);
        }

        public boolean preventSpawning(EntityType<?> entityType) {
            if (this.mobWhitelist.contains(entityType)) {
                return false;
            }
            if (this.blockedMobCategories.contains(entityType.getCategory())) {
                return true;
            }
            return this.mobBlacklist.contains(entityType);
        }
    }

    public static class BlockedMobCategoriesConfig
    implements ConfigCore {
        @Config(description={"Night time monsters, illagers, nether creatures, etc."})
        public boolean monster;
        @Config(description={"Animals, passive mobs, villagers, etc."})
        public boolean creature;
        @Config(description={"Squids, fishes, axolotls, etc."})
        public boolean aquatic;

        public Set<MobCategoryGroup> toGroupSet() {
            HashSet<MobCategoryGroup> set = new HashSet<MobCategoryGroup>();
            if (this.monster) {
                set.add(MobCategoryGroup.MONSTER);
            }
            if (this.creature) {
                set.add(MobCategoryGroup.CREATURE);
            }
            if (this.aquatic) {
                set.add(MobCategoryGroup.AQUATIC);
            }
            return Sets.immutableEnumSet(set);
        }

        public Set<MobCategory> toValueSet() {
            return (Set)this.toGroupSet().stream().mapMulti(MobCategoryGroup::addAll).collect(ImmutableSet.toImmutableSet());
        }
    }

    public static class BlockedSpawnReasonsConfig
    implements ConfigCore {
        @Config(description={"Monsters spawned during night time, cats in villages, phantoms in the sky."})
        public boolean natural;
        @Config(description={"All kinds of mobs summoned by monster spawners."})
        public boolean spawner;
        @Config(description={"Zombified piglin from nether portals."})
        public boolean structure;
        @Config(description={"Iron golems from villagers."})
        public boolean summoned;
        @Config(description={"Mobs spawned by game events, mainly zombie sieges, raids, wandering trader visits."})
        public boolean event;
        @Config(description={"Zombie reinforcements spawned when a zombie is hurt."})
        public boolean reinforcement;
        @Config(description={"Pillager patrols."})
        public boolean patrol;
        @Config(description={"Skeleton horse traps and warden from sculk shriekers."})
        public boolean triggered;

        public Set<MobSpawnType> toSet() {
            HashSet<MobSpawnType> set = new HashSet<MobSpawnType>();
            if (this.natural) {
                set.add(MobSpawnType.NATURAL);
                set.add(MobSpawnType.JOCKEY);
            }
            if (this.spawner) {
                set.add(MobSpawnType.SPAWNER);
                set.add(MobSpawnType.TRIAL_SPAWNER);
            }
            if (this.structure) {
                set.add(MobSpawnType.STRUCTURE);
            }
            if (this.summoned) {
                set.add(MobSpawnType.MOB_SUMMONED);
            }
            if (this.event) {
                set.add(MobSpawnType.EVENT);
            }
            if (this.reinforcement) {
                set.add(MobSpawnType.REINFORCEMENT);
            }
            if (this.patrol) {
                set.add(MobSpawnType.PATROL);
            }
            if (this.triggered) {
                set.add(MobSpawnType.TRIGGERED);
            }
            return Sets.immutableEnumSet(set);
        }
    }
}

