/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.attachment;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import fuzs.magnumtorch.attachment.TypedBlockArea;
import fuzs.magnumtorch.init.ModRegistry;
import fuzs.magnumtorch.world.level.block.MagnumTorchBlock;
import fuzs.magnumtorch.world.level.block.MagnumTorchType;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public final class TorchPositions {
    public static final TorchPositions EMPTY = new TorchPositions();
    public static final Codec<TorchPositions> CODEC = TypedBlockArea.CODEC.listOf().xmap(TorchPositions::new, torchPositions -> new ArrayList<TypedBlockArea>(torchPositions.torchPositions.values()));
    private final Map<BlockPos, TypedBlockArea> torchPositions;
    private final Long2ObjectMap<Map<BlockPos, TypedBlockArea>> sectionPositions;

    private TorchPositions() {
        this.torchPositions = Collections.emptyMap();
        this.sectionPositions = Long2ObjectMaps.emptyMap();
    }

    private TorchPositions(List<TypedBlockArea> torchPositions) {
        this(torchPositions.stream().collect(Collectors.toMap(TypedBlockArea::position, Function.identity())), TorchPositions.createSectionPositions(torchPositions));
    }

    private TorchPositions(Map<BlockPos, TypedBlockArea> torchPositions, Long2ObjectMap<Map<BlockPos, TypedBlockArea>> sectionPositions) {
        this.torchPositions = torchPositions;
        this.sectionPositions = sectionPositions;
    }

    private static Long2ObjectMap<Map<BlockPos, TypedBlockArea>> createSectionPositions(List<TypedBlockArea> torchPositions) {
        Long2ObjectOpenHashMap sectionPositions = new Long2ObjectOpenHashMap();
        for (TypedBlockArea torchPosition : torchPositions) {
            TorchPositions.addAllSections(torchPosition, (Long2ObjectMap<Map<BlockPos, TypedBlockArea>>)sectionPositions);
        }
        return sectionPositions;
    }

    private static void addAllSections(TypedBlockArea torchPosition, Long2ObjectMap<Map<BlockPos, TypedBlockArea>> sectionPositions) {
        torchPosition.blockArea().getAllSections(sectionPos -> {
            Map positions = (Map)sectionPositions.computeIfAbsent(sectionPos.asLong(), sectionPosX -> new LinkedHashMap());
            positions.put(torchPosition.position(), torchPosition);
        });
    }

    private static void removeAllSections(TypedBlockArea torchPosition, Long2ObjectMap<Map<BlockPos, TypedBlockArea>> sectionPositions) {
        torchPosition.blockArea().getAllSections(sectionPos -> {
            Map positions = (Map)sectionPositions.get(sectionPos.asLong());
            if (positions != null) {
                positions.remove(torchPosition.position(), torchPosition);
                if (positions.isEmpty()) {
                    sectionPositions.remove(sectionPos.asLong(), (Object)positions);
                }
            }
        });
    }

    public Collection<? extends TypedBlockArea> getTorchesInSection(BlockPos blockPos) {
        return ((Map)this.sectionPositions.getOrDefault(SectionPos.asLong((BlockPos)blockPos), Collections.emptyMap())).values();
    }

    public TorchPositions add(BlockPos blockPos, MagnumTorchType type) {
        TypedBlockArea oldType = this.torchPositions.get(blockPos);
        if (oldType == null || oldType.type() != type) {
            TypedBlockArea torchPosition = new TypedBlockArea(type, blockPos);
            ImmutableMap torchPositions = ImmutableMap.builder().putAll(this.torchPositions).put((Object)blockPos, (Object)torchPosition).buildKeepingLast();
            Long2ObjectOpenHashMap sectionPositions = new Long2ObjectOpenHashMap(this.sectionPositions);
            TorchPositions.addAllSections(torchPosition, (Long2ObjectMap<Map<BlockPos, TypedBlockArea>>)sectionPositions);
            return new TorchPositions((Map<BlockPos, TypedBlockArea>)torchPositions, (Long2ObjectMap<Map<BlockPos, TypedBlockArea>>)sectionPositions);
        }
        return this;
    }

    public TorchPositions remove(BlockPos blockPos, MagnumTorchType type) {
        TypedBlockArea oldType = this.torchPositions.get(blockPos);
        if (oldType != null && oldType.type() == type) {
            Map torchPositions = (Map)this.torchPositions.entrySet().stream().filter(entry -> !((BlockPos)entry.getKey()).equals((Object)blockPos)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            Long2ObjectOpenHashMap sectionPositions = new Long2ObjectOpenHashMap(this.sectionPositions);
            TorchPositions.removeAllSections(oldType, (Long2ObjectMap<Map<BlockPos, TypedBlockArea>>)sectionPositions);
            return new TorchPositions(torchPositions, (Long2ObjectMap<Map<BlockPos, TypedBlockArea>>)sectionPositions);
        }
        return this;
    }

    public static void onBlockStateChange(ServerLevel serverLevel, BlockPos pos, BlockState oldState, BlockState newState) {
        Optional<MagnumTorchType> newType;
        Optional<MagnumTorchType> oldType = TorchPositions.getMagnumTorchType(oldState);
        if (!Objects.equals(oldType, newType = TorchPositions.getMagnumTorchType(newState))) {
            BlockPos blockPos = pos.immutable();
            oldType.ifPresent(type -> serverLevel.getServer().execute(() -> {
                TorchPositions torchPositions = (TorchPositions)ModRegistry.TORCH_POSITIONS_ATTACHMENT_TYPE.getOrDefault((Object)serverLevel, (Object)EMPTY);
                ModRegistry.TORCH_POSITIONS_ATTACHMENT_TYPE.set((Object)serverLevel, (Object)torchPositions.remove(blockPos, (MagnumTorchType)((Object)type)));
            }));
            newType.ifPresent(type -> serverLevel.getServer().execute(() -> {
                TorchPositions torchPositions = (TorchPositions)ModRegistry.TORCH_POSITIONS_ATTACHMENT_TYPE.getOrDefault((Object)serverLevel, (Object)EMPTY);
                ModRegistry.TORCH_POSITIONS_ATTACHMENT_TYPE.set((Object)serverLevel, (Object)torchPositions.add(blockPos, (MagnumTorchType)((Object)type)));
            }));
        }
    }

    private static Optional<MagnumTorchType> getMagnumTorchType(BlockState blockState) {
        Optional<MagnumTorchType> optional;
        Block block = blockState.getBlock();
        if (block instanceof MagnumTorchBlock) {
            MagnumTorchBlock block2 = (MagnumTorchBlock)block;
            optional = Optional.of(block2.getType());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

