/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.attachment;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.magnumtorch.config.ShapeType;
import fuzs.magnumtorch.world.level.block.MagnumTorchType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.ExtraCodecs;

public record BlockArea(BlockPos position, int horizontalRange, int verticalRange, ShapeType shape) {
    private static final Map<BlockArea, List<SectionPos>> BLOCK_AREA_SECTIONS = new ConcurrentHashMap<BlockArea, List<SectionPos>>();
    public static final MapCodec<BlockArea> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPos.CODEC.fieldOf("position").forGetter(BlockArea::position), (App)ExtraCodecs.POSITIVE_INT.fieldOf("horizontal_range").forGetter(BlockArea::horizontalRange), (App)ExtraCodecs.POSITIVE_INT.fieldOf("vertical_range").forGetter(BlockArea::verticalRange), (App)ShapeType.CODEC.fieldOf("shape").forGetter(BlockArea::shape)).apply((Applicative)instance, BlockArea::new));

    BlockArea(MagnumTorchType type, BlockPos position) {
        this(position, type.getConfig().horizontalRange(), type.getConfig().verticalRange(), type.getConfig().shapeType);
    }

    public boolean isPositionInside(BlockPos blockPos) {
        return this.shape().isPositionInside(this.position(), blockPos, this.horizontalRange(), this.verticalRange());
    }

    public void getAllSections(Consumer<SectionPos> sectionConsumer) {
        BLOCK_AREA_SECTIONS.computeIfAbsent(this.asKey(), blockArea -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            BlockArea.getAllSections(this.position(), this.horizontalRange(), this.verticalRange(), this.shape(), arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return builder.build();
        }).forEach(sectionConsumer);
    }

    private BlockArea asKey() {
        return new BlockArea(SectionPos.of((BlockPos)this.position()).origin(), this.horizontalRange(), this.verticalRange(), this.shape());
    }

    public static void getAllSections(BlockPos blockPos, int horizontalRange, int verticalRange, ShapeType shapeType, Consumer<SectionPos> sectionPosConsumer) {
        SectionPos minSection = SectionPos.of((BlockPos)blockPos.offset(-horizontalRange, -verticalRange, -horizontalRange));
        SectionPos maxSection = SectionPos.of((BlockPos)blockPos.offset(horizontalRange, verticalRange, horizontalRange));
        for (int sectionX = minSection.x(); sectionX <= maxSection.x(); ++sectionX) {
            int posX = BlockArea.getClosestCoordinate(blockPos.getX(), sectionX);
            for (int sectionY = minSection.y(); sectionY <= maxSection.y(); ++sectionY) {
                int posY = BlockArea.getClosestCoordinate(blockPos.getY(), sectionY);
                for (int sectionZ = minSection.z(); sectionZ <= maxSection.z(); ++sectionZ) {
                    int posZ = BlockArea.getClosestCoordinate(blockPos.getZ(), sectionZ);
                    if (!shapeType.isPositionInside(blockPos.getX(), blockPos.getY(), blockPos.getZ(), posX, posY, posZ, horizontalRange, verticalRange)) continue;
                    sectionPosConsumer.accept(SectionPos.of((int)sectionX, (int)sectionY, (int)sectionZ));
                }
            }
        }
    }

    private static int getClosestCoordinate(int blockCoordinate, int sectionCoordinate) {
        int min = SectionPos.sectionToBlockCoord((int)sectionCoordinate);
        if (blockCoordinate < min) {
            return min;
        }
        int max = SectionPos.sectionToBlockCoord((int)sectionCoordinate, (int)15);
        if (blockCoordinate > max) {
            return max;
        }
        return blockCoordinate;
    }
}

