/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.integration.neoforge.create;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.starfish_studios.another_furniture.entity.SeatEntity;
import com.starfish_studios.another_furniture.mixin.neoforge.create.ContraptionMixin;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SeatMovementBehavior
implements MovementBehaviour {
    public void startMoving(MovementContext context) {
        super.startMoving(context);
        int indexOf = context.contraption.getSeats().indexOf(context.localPos);
        context.data.putInt("SeatIndex", indexOf);
        this.moveSeat(context.contraption, context.world, context.localPos);
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        AbstractContraptionEntity contraptionEntity = context.contraption.entity;
        if (contraptionEntity == null) {
            return;
        }
        int index = context.data.getInt("SeatIndex");
        if (index == -1) {
            return;
        }
        Map seatMapping = context.contraption.getSeatMapping();
        if (!seatMapping.containsValue(index)) {
            return;
        }
        Entity toDismount = null;
        for (Map.Entry entry : seatMapping.entrySet()) {
            if ((Integer)entry.getValue() != index) continue;
            for (Entity entity : contraptionEntity.getPassengers()) {
                if (!((UUID)entry.getKey()).equals(entity.getUUID())) continue;
                toDismount = entity;
            }
        }
        if (toDismount == null) {
            return;
        }
        toDismount.stopRiding();
        Vec3 position = VecHelper.getCenterOf((Vec3i)pos).add(0.0, 1.0, 0.0);
        toDismount.teleportTo(position.x, position.y, position.z);
    }

    private void moveSeat(Contraption contraption, Level world, BlockPos pos) {
        BlockPos globalPos = pos.offset((Vec3i)contraption.anchor);
        contraption.getSeats().add(pos);
        List seatsEntities = world.getEntitiesOfClass(SeatEntity.class, new AABB(globalPos));
        if (seatsEntities.isEmpty()) {
            return;
        }
        SeatEntity seat = (SeatEntity)((Object)seatsEntities.get(0));
        List passengers = seat.getPassengers();
        if (passengers.isEmpty()) {
            return;
        }
        Map<BlockPos, Entity> initialPassengers = ((ContraptionMixin)contraption).getInitialPassengers();
        initialPassengers.put(pos, (Entity)passengers.get(0));
        ((ContraptionMixin)contraption).setInitialPassengers(initialPassengers);
    }
}

