/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.starfish_studios.another_furniture.AnotherFurniture;
import com.starfish_studios.another_furniture.block.entity.ServiceBellBlockEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ServiceBellButtonRenderer
implements BlockEntityRenderer<ServiceBellBlockEntity> {
    public static final Material BELL_TEXTURE = new Material(InventoryMenu.BLOCK_ATLAS, AnotherFurniture.res("block/service_bell"));
    public static ModelLayerLocation SERVICE_BELL_MODEL = new ModelLayerLocation(AnotherFurniture.res("service_bell"), "service_bell");
    private final ModelPart button;

    public ServiceBellButtonRenderer(BlockEntityRendererProvider.Context context) {
        this.button = context.bakeLayer(SERVICE_BELL_MODEL);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("button", CubeListBuilder.create().texOffs(19, 11).addBox(-9.0f, -7.0f, 7.0f, 2.0f, 1.0f, 2.0f), PartPose.ZERO);
        partdefinition.getChild("button").addOrReplaceChild("button_shaft", CubeListBuilder.create().texOffs(0, 0).addBox(-8.5f, -6.0f, 7.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void render(ServiceBellBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float f3 = 0.0f;
        if (blockEntity.pressed) {
            f3 = -((float)blockEntity.ticks / 25.0f);
        }
        poseStack.translate(0.0f, f3, 0.0f);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.button.render(poseStack, BELL_TEXTURE.buffer(bufferSource, RenderType::entitySolid), packedLight, packedOverlay);
        poseStack.popPose();
    }
}

