/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.starfish_studios.another_furniture.block.FlowerBoxBlock;
import com.starfish_studios.another_furniture.block.entity.FlowerBoxBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlowerBoxRenderer
implements BlockEntityRenderer<FlowerBoxBlockEntity> {
    private BlockRenderDispatcher blockRenderer;

    public FlowerBoxRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(FlowerBoxBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction facing = ((Direction)blockEntity.getBlockState().getValue((Property)FlowerBoxBlock.FACING)).getOpposite();
        float rotation = -facing.toYRot();
        BlockState upper = null;
        poseStack.pushPose();
        poseStack.scale(0.7f, 0.7f, 0.7f);
        poseStack.translate(0.0f, 0.4f, 0.0f);
        for (int i = 0; i < 2; ++i) {
            BlockState lower;
            Item item = blockEntity.getItemFromSlot(i);
            if (item == Items.AIR) continue;
            Block block = ((BlockItem)item).getBlock();
            if (block instanceof DoublePlantBlock) {
                lower = (BlockState)block.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                upper = (BlockState)block.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
            } else {
                lower = block.defaultBlockState();
            }
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
            poseStack.translate((double)0.6f - 0.8 * (double)i, (double)(0.001f * (float)i), (double)0.2f);
            poseStack.translate(0.0f, 0.001f * (float)i, 0.001f * (float)i);
            switch ((Direction)blockEntity.getBlockState().getValue((Property)FlowerBoxBlock.FACING)) {
                case EAST: {
                    poseStack.translate(0.0f, 0.0f, -1.4f);
                    break;
                }
                case WEST: {
                    poseStack.translate(-1.4f, 0.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.translate(-1.4f, 0.0f, -1.4f);
                }
            }
            if (((Boolean)blockEntity.getBlockState().getValue((Property)FlowerBoxBlock.ATTACHED)).booleanValue()) {
                poseStack.translate(0.0f, 0.9f, 0.36f);
            }
            this.blockRenderer.renderSingleBlock(lower, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            if (upper != null) {
                poseStack.translate(0.0f, 1.0f, 0.0f);
                this.blockRenderer.renderSingleBlock(upper, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

