/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.mojang.serialization.MapCodec;
import com.starfish_studios.another_furniture.block.entity.ShelfBlockEntity;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.util.block.BlockPart;
import com.starfish_studios.another_furniture.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SmallShelfBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<SmallShelfBlock> CODEC = SmallShelfBlock.simpleCodec(SmallShelfBlock::new);
    public static final EnumProperty<HorizontalConnectionType> TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final EnumProperty<SlabType> HALF = ModBlockStateProperties.HALF;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape TOP_AABB_NORTH = Block.box((double)0.0, (double)14.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB_NORTH = Block.box((double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape DOUBLE_AABB_NORTH = Shapes.or((VoxelShape)TOP_AABB_NORTH, (VoxelShape)BOTTOM_AABB_NORTH);
    protected static final VoxelShape TOP_AABB_EAST = ShapeUtil.rotateShape(TOP_AABB_NORTH, Direction.EAST);
    protected static final VoxelShape BOTTOM_AABB_EAST = ShapeUtil.rotateShape(BOTTOM_AABB_NORTH, Direction.EAST);
    protected static final VoxelShape DOUBLE_AABB_EAST = ShapeUtil.rotateShape(DOUBLE_AABB_NORTH, Direction.EAST);
    protected static final VoxelShape TOP_AABB_SOUTH = ShapeUtil.rotateShape(TOP_AABB_NORTH, Direction.SOUTH);
    protected static final VoxelShape BOTTOM_AABB_SOUTH = ShapeUtil.rotateShape(BOTTOM_AABB_NORTH, Direction.SOUTH);
    protected static final VoxelShape DOUBLE_AABB_SOUTH = ShapeUtil.rotateShape(DOUBLE_AABB_NORTH, Direction.SOUTH);
    protected static final VoxelShape TOP_AABB_WEST = ShapeUtil.rotateShape(TOP_AABB_NORTH, Direction.WEST);
    protected static final VoxelShape BOTTOM_AABB_WEST = ShapeUtil.rotateShape(BOTTOM_AABB_NORTH, Direction.WEST);
    protected static final VoxelShape DOUBLE_AABB_WEST = ShapeUtil.rotateShape(DOUBLE_AABB_NORTH, Direction.WEST);

    public MapCodec<SmallShelfBlock> codec() {
        return CODEC;
    }

    public SmallShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).setValue(HALF, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemStack = useContext.getItemInHand();
        SlabType slabType = (SlabType)state.getValue(HALF);
        if (slabType == SlabType.DOUBLE || !itemStack.is(this.asItem())) {
            return false;
        }
        if (!useContext.replacingClickedOnBlock()) {
            return true;
        }
        boolean bl = useContext.getClickLocation().y - (double)useContext.getClickedPos().getY() > 0.5;
        Direction direction = useContext.getClickedFace();
        if (slabType == SlabType.BOTTOM) {
            return direction == Direction.UP || bl && direction.getAxis().isHorizontal();
        }
        return direction == Direction.DOWN || !bl && direction.getAxis().isHorizontal();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (!(blockentity instanceof ShelfBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
        Direction facing = (Direction)state.getValue((Property)FACING);
        int slot = BlockPart.get2D(pos, hitResult.getLocation(), Direction.UP, facing.getClockWise(), 2, 2);
        if (!stack.isEmpty()) {
            if (!level.isClientSide && shelfBE.placeItem(player.getAbilities().instabuild ? stack.copy() : stack, slot)) {
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        if (shelfBE.removeItem(slot, player, level)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
            Containers.dropContents((Level)level, (BlockPos)pos, shelfBE.getItems());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        HorizontalConnectionType type = (HorizontalConnectionType)((Object)state.getValue(TYPE));
        SlabType half = (SlabType)state.getValue(HALF);
        if (direction == Direction.NORTH) {
            return switch (half) {
                case SlabType.TOP -> TOP_AABB_NORTH;
                case SlabType.DOUBLE -> DOUBLE_AABB_NORTH;
                default -> BOTTOM_AABB_NORTH;
            };
        }
        if (direction == Direction.EAST) {
            return switch (half) {
                case SlabType.TOP -> TOP_AABB_EAST;
                case SlabType.DOUBLE -> DOUBLE_AABB_EAST;
                default -> BOTTOM_AABB_EAST;
            };
        }
        if (direction == Direction.SOUTH) {
            return switch (half) {
                case SlabType.TOP -> TOP_AABB_SOUTH;
                case SlabType.DOUBLE -> DOUBLE_AABB_SOUTH;
                default -> BOTTOM_AABB_SOUTH;
            };
        }
        return switch (half) {
            case SlabType.TOP -> TOP_AABB_WEST;
            case SlabType.DOUBLE -> DOUBLE_AABB_WEST;
            default -> BOTTOM_AABB_WEST;
        };
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPos = context.getClickedPos();
        BlockState stateExisting = context.getLevel().getBlockState(clickedPos);
        if (stateExisting.is((Block)this)) {
            return (BlockState)stateExisting.setValue(HALF, (Comparable)SlabType.DOUBLE);
        }
        boolean waterlogged = context.getLevel().getFluidState(clickedPos).getType() == Fluids.WATER;
        BlockState state = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)SlabType.BOTTOM)).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        Direction direction = context.getClickedFace();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.getClickLocation().y - (double)clickedPos.getY() > 0.5) ? state : (BlockState)state.setValue(HALF, (Comparable)SlabType.TOP);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean sideR;
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        BlockState above = level.getBlockState(currentPos.above());
        if (direction == Direction.UP && above.isFaceSturdy((BlockGetter)level, currentPos, Direction.DOWN) && !above.getVisualShape((BlockGetter)level, currentPos.above(), CollisionContext.empty()).isEmpty() && (blockEntity = level.getBlockEntity(currentPos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockEntity;
            shelfBE.removeAllItems();
        }
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Direction dirL = facing.getClockWise();
        Direction dirR = facing.getCounterClockWise();
        if (direction != dirL && direction != dirR) {
            return state;
        }
        BlockState stateL = level.getBlockState(currentPos.relative(dirL));
        BlockState stateR = level.getBlockState(currentPos.relative(dirR));
        boolean sideL = stateL.getBlock() instanceof SmallShelfBlock && stateL.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == facing;
        boolean bl = sideR = stateR.getBlock() instanceof SmallShelfBlock && stateR.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == facing;
        HorizontalConnectionType type = sideL && sideR ? HorizontalConnectionType.MIDDLE : (sideR ? HorizontalConnectionType.LEFT : (sideL ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, HALF, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

