/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.entity.SeatEntity;
import com.starfish_studios.another_furniture.registry.AFBlockTags;
import com.starfish_studios.another_furniture.registry.AFEntityTypeTags;
import com.starfish_studios.another_furniture.registry.AFRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class SeatBlock
extends Block {
    public SeatBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float seatHeight(BlockState state) {
        return 0.35f;
    }

    public boolean isSittable(BlockState state) {
        return true;
    }

    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos;
    }

    public float setRiderRotation(BlockState state, Entity entity) {
        return entity.getYRot();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (AFRegistry.isFakePlayer(player)) {
            return InteractionResult.PASS;
        }
        if (!level.mayInteract(player, pos)) {
            return InteractionResult.PASS;
        }
        if (!this.isSittable(state) || player.isPassenger() || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        if (SeatBlock.isSeatBlocked(level, pos)) {
            return InteractionResult.PASS;
        }
        if (SeatBlock.isSeatOccupied(level, pos)) {
            List seats = level.getEntitiesOfClass(SeatEntity.class, new AABB(pos));
            if (SeatBlock.ejectSeatedExceptPlayer(level, (SeatEntity)((Object)seats.get(0)))) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        SeatBlock.sitDown(level, pos, SeatBlock.getLeashed(player).orElse((Entity)player));
        return InteractionResult.SUCCESS;
    }

    public static boolean isSeatBlocked(Level level, BlockPos pos) {
        return !level.getBlockState(pos.above()).getCollisionShape((BlockGetter)level, pos).isEmpty() && !level.getBlockState(pos.above()).is(AFBlockTags.ABOVE_BYPASSES_SEAT_CHECK);
    }

    public static boolean isSeatOccupied(Level level, BlockPos pos) {
        return !level.getEntitiesOfClass(SeatEntity.class, new AABB(pos)).isEmpty();
    }

    public static Optional<Entity> getLeashed(Player player) {
        List entities = player.level().getEntities((Entity)null, player.getBoundingBox().inflate(10.0), e -> true);
        for (Entity e2 : entities) {
            Mob mob;
            if (e2 instanceof Mob && (mob = (Mob)e2).getLeashHolder() == player && SeatBlock.canBePickedUp(e2)) {
                return Optional.of(mob);
            }
            if (!(e2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)e2;
            if (e2 instanceof Mob || !SeatBlock.canBePickedUp(e2)) continue;
            return Optional.of(living);
        }
        return Optional.empty();
    }

    public static boolean ejectSeatedExceptPlayer(Level level, SeatEntity seatEntity) {
        List passengers = seatEntity.getPassengers();
        if (!passengers.isEmpty() && passengers.get(0) instanceof Player) {
            return false;
        }
        if (!level.isClientSide) {
            seatEntity.ejectPassengers();
        }
        return true;
    }

    public static boolean canBePickedUp(Entity passenger) {
        TamableAnimal ta;
        if (passenger instanceof Player) {
            return false;
        }
        if (passenger instanceof TamableAnimal && !(ta = (TamableAnimal)passenger).isTame()) {
            return false;
        }
        return passenger instanceof LivingEntity && passenger.getType().is(AFEntityTypeTags.CAN_SIT_IN_SEATS);
    }

    public static void sitDown(Level level, BlockPos pos, Entity entity) {
        if (level.isClientSide) {
            return;
        }
        SeatEntity seat = new SeatEntity(level, pos);
        level.addFreshEntity((Entity)seat);
        entity.startRiding((Entity)seat);
        level.updateNeighbourForOutputSignal(pos, level.getBlockState(pos).getBlock());
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.setInSittingPose(true);
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return SeatBlock.isSeatOccupied(level, pos) ? 15 : 0;
    }
}

