/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.util;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.GameObjectLookup;
import snownee.snow.GameEvents;
import snownee.snow.Hooks;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.compat.diagonalfences.DiagonalFencesCompat;
import snownee.snow.compat.diagonalwalls.DiagonalWallsCompat;
import snownee.snow.compat.sereneseasons.SereneSeasonsCompat;
import snownee.snow.util.ClientProxy;

@Mod(value="snowrealmagic")
public class CommonProxy {
    public static boolean fabricSeasons = Platform.isModLoaded((String)"seasons");
    public static boolean sereneSeasons = Platform.isModLoaded((String)"sereneseasons");

    public CommonProxy(IEventBus eventBus) {
        NeoForge.EVENT_BUS.addListener(RegisterCommandsEvent.class, event -> {
            if (SnowCommonConfig.debugSpawningCommand) {
                DebugMobSpawningCommand.register((CommandDispatcher)event.getDispatcher());
            }
        });
        NeoForge.EVENT_BUS.addListener(PlayerInteractEvent.RightClickBlock.class, event -> {
            InteractionResult result = GameEvents.onItemUse(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            if (result.consumesAction()) {
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        });
        NeoForge.EVENT_BUS.addListener(ChunkEvent.Load.class, event -> {
            ChunkAccess patt0$temp;
            if (!event.isNewChunk() && (patt0$temp = event.getChunk()) instanceof LevelChunk) {
                LevelChunk chunk = (LevelChunk)patt0$temp;
                Hooks.restoreOriginalBlocks(chunk);
            }
        });
        if (sereneSeasons) {
            SnowRealMagic.LOGGER.info("SereneSeasons detected. Overriding weather behavior.");
        }
        if (Platform.isModLoaded((String)"diagonalfences")) {
            DiagonalFencesCompat.init();
        }
        if (Platform.isModLoaded((String)"diagonalwalls")) {
            DiagonalWallsCompat.init();
        }
        if (Platform.isPhysicalClient()) {
            ClientProxy.onInitializeClient(eventBus);
        }
    }

    public static boolean isHot(FluidState fluidState, Level level, BlockPos pos) {
        return fluidState.getType().getPickupSound().orElse(null) == SoundEvents.BUCKET_FILL_LAVA || fluidState.is(FluidTags.LAVA);
    }

    public static boolean weatherTick(ServerLevel level, BooleanSupplier action) {
        if (sereneSeasons) {
            return SereneSeasonsCompat.weatherTick(level, action);
        }
        return action.getAsBoolean();
    }

    public static boolean snowAccumulationNow(Level level) {
        if (!level.isRaining()) {
            return false;
        }
        if (SnowCommonConfig.snowAccumulationDuringSnowfall) {
            return true;
        }
        return SnowCommonConfig.snowAccumulationDuringSnowstorm && (level.isThundering() || sereneSeasons);
    }

    public static boolean shouldMelt(Level level, BlockPos pos) {
        return CommonProxy.shouldMelt(level, pos, (Holder<Biome>)level.getBiome(pos), 1);
    }

    public static boolean shouldMelt(Level level, BlockPos pos, Holder<Biome> biome, int layers) {
        if (SnowCommonConfig.snowNeverMelt) {
            return false;
        }
        if (sereneSeasons) {
            return SereneSeasonsCompat.shouldMelt(level, pos, biome);
        }
        if (CommonProxy.snowAndIceMeltInWarmBiomes((ResourceKey<Level>)level.dimension(), biome) && ((Biome)biome.value()).warmEnoughToRain(pos) && CommonProxy.skyLightEnoughToMelt(level, pos, layers)) {
            return true;
        }
        if (layers <= 1) {
            if (SnowCommonConfig.snowAccumulationMaxLayers < 9) {
                return false;
            }
            if (!(level.getBlockState(pos.below()).getBlock() instanceof SnowLayerBlock)) {
                return false;
            }
        }
        return SnowCommonConfig.snowNaturalMelt && CommonProxy.skyLightEnoughToMelt(level, pos, layers);
    }

    public static boolean snowAndIceMeltInWarmBiomes(ResourceKey<Level> dimension, Holder<Biome> biome) {
        if (SnowCommonConfig.snowAndIceMeltInWarmBiomes) {
            return true;
        }
        if (sereneSeasons) {
            return SereneSeasonsCompat.snowAndIceMeltInWarmBiomes(dimension, biome);
        }
        return fabricSeasons;
    }

    public static boolean skyLightEnoughToMelt(Level level, BlockPos pos, int layers) {
        return level.getBrightness(LightLayer.SKY, layers == 8 ? pos.above() : pos) > 2;
    }

    public static boolean coldEnoughToSnow(LevelReader level, BlockPos pos, Holder<Biome> biome) {
        if (sereneSeasons) {
            return SereneSeasonsCompat.coldEnoughToSnow(level, pos, biome);
        }
        return ((Biome)biome.value()).coldEnoughToSnow(pos);
    }

    public static boolean isWinter(Level level, BlockPos pos, Holder<Biome> biome) {
        if (sereneSeasons) {
            return SereneSeasonsCompat.isWinter(level, pos, biome);
        }
        return false;
    }

    public static List<Block> allSnowBlocks() {
        return GameObjectLookup.all((ResourceKey)Registries.BLOCK, (String)"snowrealmagic").toList();
    }
}

