/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.fabricmc.fabric.api.client.model.loading.v1.FabricBakedModelManager;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import snownee.snow.client.ClientHooks;
import snownee.snow.client.SnowVariantMetadataSectionSerializer;
import snownee.snow.client.model.ModelDefinition;
import snownee.snow.client.model.SnowCoveredModel;
import snownee.snow.client.model.SnowVariantModel;
import snownee.snow.client.model.WrapperUnbakedModel;
import snownee.snow.util.CommonProxy;

public class ClientProxy {
    public static BakedModel getBlockModel(BlockState state) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
    }

    public static BakedModel getBlockModel(ResourceLocation location) {
        return ((FabricBakedModelManager)Minecraft.getInstance().getModelManager()).getModel(location);
    }

    public static void onInitializeClient(IEventBus eventBus) {
        ModelLoadingPlugin.register(ctx -> {
            ArrayList extraModels = Lists.newArrayList((Object[])new ResourceLocation[]{ClientHooks.OVERLAY_MODEL});
            ClientHooks.snowVariantMapping.clear();
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            ModelBakery.MODEL_LISTER.listMatchingResources(resourceManager).forEach((key, resource) -> {
                ModelDefinition def;
                try {
                    def = resource.metadata().getSection((MetadataSectionSerializer)SnowVariantMetadataSectionSerializer.SERIALIZER).orElse(null);
                }
                catch (IOException e) {
                    return;
                }
                if (def == null || def.model == null) {
                    return;
                }
                ClientHooks.snowVariantMapping.put(ModelBakery.MODEL_LISTER.fileToId(key), def);
                extraModels.add(def.model);
                if (def.overrideBlocks != null) {
                    for (ResourceLocation id : def.overrideBlocks) {
                        Block block = (Block)BuiltInRegistries.BLOCK.get(id);
                        if (block == Blocks.AIR) continue;
                        ClientHooks.overrideBlocks.add(block);
                    }
                }
            });
            ctx.addModels((Collection)extraModels);
            HashSet snowCoveredModelIds = Sets.newHashSet();
            HashMap transform = Maps.newHashMap();
            for (Block block : CommonProxy.allSnowBlocks()) {
                for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                    ModelResourceLocation modelId = BlockModelShaper.stateToModelLocation((ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)block), (BlockState)state);
                    snowCoveredModelIds.add(modelId);
                }
            }
            ctx.modifyModelOnLoad().register(ModelModifier.WRAP_LAST_PHASE, (model, context) -> {
                if (snowCoveredModelIds.contains(context.topLevelId())) {
                    return transform.computeIfAbsent(model, $ -> new WrapperUnbakedModel((UnbakedModel)$, SnowCoveredModel::new));
                }
                return model;
            });
            ctx.modifyModelAfterBake().register(ModelModifier.WRAP_LAST_PHASE, (model, context) -> {
                ModelState modelState = context.settings();
                if (model == null || modelState.getClass() != Variant.class) {
                    return model;
                }
                ModelDefinition def = ClientHooks.snowVariantMapping.get(context.resourceId());
                if (def == null) {
                    return model;
                }
                Variant variantState = (Variant)modelState;
                variantState = new Variant(def.model, variantState.getRotation(), variantState.isUvLocked(), variantState.getWeight());
                BakedModel variantModel = context.baker().bake(def.model, (ModelState)variantState);
                if (variantModel == null) {
                    return model;
                }
                return new SnowVariantModel(model, variantModel);
            });
            ClientHooks.cachedOverlayModel = null;
            ClientHooks.cachedSnowModel = null;
        });
        eventBus.addListener(FMLCommonSetupEvent.class, event -> event.enqueueWork(() -> {
            for (Block block : CommonProxy.allSnowBlocks()) {
                ItemBlockRenderTypes.setRenderLayer((Block)block, (ChunkRenderTypeSet)ChunkRenderTypeSet.all());
            }
        }));
    }
}

