/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.compat.diagonalwalls;

import com.google.common.collect.BiMap;
import fuzs.diagonalblocks.api.v2.DiagonalBlockType;
import fuzs.diagonalblocks.api.v2.client.MultiPartTranslator;
import fuzs.diagonalblocks.api.v2.impl.DiagonalBlockTypeImpl;
import fuzs.diagonalblocks.api.v2.impl.DiagonalWallBlock;
import fuzs.diagonalblocks.client.resources.model.WallMultiPartTranslator;
import fuzs.diagonalwalls.DiagonalWalls;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.SnowRealMagic;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.SnowWallBlock;
import snownee.snow.compat.diagonalwalls.SnowDiagonalWallBlock;
import snownee.snow.convert.CoveredBlockConverter;

@KiwiModule(value="diagonalwalls", dependencies="diagonalwalls")
@NotNullByDefault
public class DiagonalWallsCompat
extends AbstractModule {
    public static final String ID = "diagonalwalls";
    public static final DiagonalBlockType TYPE = new DiagonalBlockTypeImpl("snowwalls", SnowWallBlock.class, SnowDiagonalWallBlock::new, new Property[]{WallBlock.UP, WallBlock.NORTH_WALL, WallBlock.EAST_WALL, WallBlock.WEST_WALL, WallBlock.SOUTH_WALL, WallBlock.WATERLOGGED, SnowVariant.OPTIONAL_LAYERS}){

        public ResourceLocation id(String path) {
            return DiagonalWalls.id((String)path);
        }
    };

    public static void init() {
        DiagonalBlockType.register((DiagonalBlockType)TYPE);
        if (Platform.isPhysicalClient()) {
            MultiPartTranslator.register((DiagonalBlockType)TYPE, (MultiPartTranslator)new WallMultiPartTranslator());
        }
    }

    public static BiMap<Block, Block> getBlockConversions() {
        return TYPE.getBlockConversions();
    }

    protected void postInit(PostInitEvent event) {
        event.enqueueWork(() -> CoreModule.CONVERTERS.converters.putBefore(SnowRealMagic.id("wall"), ResourceLocation.fromNamespaceAndPath((String)ID, (String)"wall"), new CoveredBlockConverter(this, DiagonalWallBlock.class, CoreModule.WALL.defaultBlockState()){

            @Override
            public boolean accept(BlockState blockState) {
                Block block = this.result.getBlock();
                return TYPE.getBlockConversions().containsKey((Object)block) && super.accept(blockState);
            }

            @Override
            public BlockState result(BlockState blockState) {
                Block block = this.result.getBlock();
                return ((Block)TYPE.getBlockConversions().getOrDefault((Object)block, (Object)block)).defaultBlockState();
            }
        }));
    }
}

