/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.SnowRealMagic;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.client.RenderAPI;
import snownee.snow.client.SnowClientConfig;
import snownee.snow.client.model.ModelDefinition;
import snownee.snow.util.ClientProxy;

@NotNullByDefault
public final class ClientHooks {
    public static BakedModel cachedSnowModel;
    public static BakedModel cachedOverlayModel;
    public static final ResourceLocation OVERLAY_MODEL;
    public static final Map<ResourceLocation, ModelDefinition> snowVariantMapping;
    public static final Set<Block> overrideBlocks;

    @CanIgnoreReturnValue
    public static boolean renderHook(BlockState blockState, BlockState camo, SnowBlockEntity.Options options, @Nullable RenderType renderType, RenderAPI api) {
        BlockState snow;
        double yOffset;
        boolean full;
        boolean rendered = false;
        SnowVariant snowVariant = (SnowVariant)blockState.getBlock();
        boolean bl = full = blockState.hasProperty((Property)SnowLayerBlock.LAYERS) && (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS) == 8 && !camo.is(CoreModule.EXPAND_MODEL);
        if (!full && !camo.isAir() && camo.getRenderShape() == RenderShape.MODEL) {
            boolean useVariant = SnowClientConfig.snowVariants && overrideBlocks.contains(camo.getBlock());
            yOffset = camo.is(CoreModule.OFFSET_Y) ? 0.101 : 0.0;
            rendered |= api.render(camo, ClientProxy.getBlockModel(camo), yOffset, RenderAPI.ModelPart.CAMO);
            if (!useVariant && (renderType == null || renderType == RenderType.cutoutMipped()) && snowVariant.srm$canRenderDecoration(blockState)) {
                rendered |= api.render(blockState, ClientProxy.getBlockModel(blockState), yOffset + snowVariant.srm$renderDecorationOffset(blockState), RenderAPI.ModelPart.DECORATION);
            }
        }
        if (!(snow = snowVariant.srm$getSnowState(blockState, (BlockGetter)api.level(), api.pos())).isAir()) {
            BakedModel model;
            if (snow == Blocks.SNOW.defaultBlockState()) {
                if (cachedSnowModel == null) {
                    cachedSnowModel = ClientProxy.getBlockModel(snow);
                }
                model = cachedSnowModel;
            } else {
                model = ClientProxy.getBlockModel(snow);
            }
            rendered |= api.render(snow, model, snowVariant.srm$renderLayerOffset(blockState), RenderAPI.ModelPart.SNOW_LAYER);
        }
        if (options.renderOverlay && (renderType == null || renderType == RenderType.cutoutMipped()) && snowVariant.srm$canRenderOverlay(blockState)) {
            if (cachedOverlayModel == null) {
                cachedOverlayModel = ClientProxy.getBlockModel(OVERLAY_MODEL);
            }
            yOffset = snowVariant.srm$renderLayerOffset(blockState) - 1.0;
            if (snowVariant.srm$layers(blockState, (BlockGetter)api.level(), api.pos()) == 8) {
                yOffset -= 0.002;
            }
            rendered |= api.render(blockState, cachedOverlayModel, yOffset, RenderAPI.ModelPart.SNOW_OVERLAY);
        }
        return rendered;
    }

    static {
        OVERLAY_MODEL = SnowRealMagic.id("block/overlay");
        snowVariantMapping = Maps.newLinkedHashMap();
        overrideBlocks = Sets.newHashSet();
    }
}

