/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block.entity;

import net.fabricmc.fabric.api.blockview.v2.RenderDataBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import snownee.kiwi.block.entity.ModBlockEntity;
import snownee.kiwi.util.KUtil;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.CoreModule;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.RenderData;

@NotNullByDefault
public class SnowBlockEntity
extends ModBlockEntity
implements RenderDataBlockEntity {
    private RenderData renderData;
    public Options options = new Options();
    protected BlockState containedState = Blocks.AIR.defaultBlockState();

    public SnowBlockEntity(BlockPos pos, BlockState containedState) {
        this((BlockEntityType)CoreModule.TILE.get(), pos, containedState);
    }

    public SnowBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState containedState) {
        super(type, pos, containedState);
    }

    public BlockState getContainedState() {
        return this.containedState;
    }

    public void setContainedState(BlockState state) {
        this.setContainedState(state, true);
    }

    public boolean setContainedState(BlockState state, boolean update) {
        if (this.containedState == state || state.getBlock() instanceof SnowVariant) {
            return false;
        }
        this.containedState = state;
        if (this.level != null && update) {
            if (this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 11);
            } else {
                this.refresh();
            }
        }
        return true;
    }

    protected void readPacketData(CompoundTag data) {
        this.loadContainedState(data, true);
    }

    public void loadContainedState(CompoundTag data, boolean network) {
        boolean changed = this.options.renderOverlay != data.getBoolean("RO");
        this.options.renderOverlay = data.getBoolean("RO");
        if ((changed |= this.setContainedState(SnowBlockEntity.parseContainedState(data), network)) && network) {
            this.refresh();
        }
    }

    public static BlockState parseContainedState(CompoundTag data) {
        if (data.contains("Block")) {
            return ((Block)BuiltInRegistries.BLOCK.get(KUtil.RL((String)data.getString("Block")))).defaultBlockState();
        }
        return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)data.getCompound("State"));
    }

    public void saveContainedState(CompoundTag data, boolean network) {
        if (this.getContainedState() == this.getContainedState().getBlock().defaultBlockState()) {
            data.putString("Block", BuiltInRegistries.BLOCK.getKey((Object)this.getContainedState().getBlock()).toString());
        } else {
            data.put("State", (Tag)NbtUtils.writeBlockState((BlockState)this.getContainedState()));
        }
        if (this.options.renderOverlay) {
            data.putBoolean("RO", true);
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.loadContainedState(compoundTag, false);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        this.saveContainedState(compoundTag, false);
    }

    protected CompoundTag writePacketData(CompoundTag compoundTag, HolderLookup.Provider provider) {
        this.saveContainedState(compoundTag, true);
        return compoundTag;
    }

    public RenderData getRenderData() {
        if (this.renderData == null || this.renderData.camo() != this.containedState) {
            this.renderData = new RenderData(this.containedState, this.options);
        }
        return this.renderData;
    }

    public static class Options {
        public boolean renderOverlay;
    }
}

