/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.NotNullByDefault;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowCoveredBlockEntity;

@NotNullByDefault
public interface WaterLoggableSnowVariant
extends EntityBlock,
SnowVariant,
SimpleWaterloggedBlock {
    default public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return fluid.isSame((Fluid)Fluids.WATER);
    }

    default public boolean placeLiquid(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        BlockState raw = this.srm$getRaw(state, (BlockGetter)worldIn, pos);
        if (raw.hasProperty((Property)BlockStateProperties.WATERLOGGED) && fluidStateIn.is((Fluid)Fluids.WATER)) {
            if (!worldIn.isClientSide()) {
                worldIn.setBlock(pos, (BlockState)raw.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.scheduleTick(pos, fluidStateIn.getType(), fluidStateIn.getType().getTickDelay((LevelReader)worldIn));
            }
            return true;
        }
        return false;
    }

    default public ItemStack pickupBlock(@Nullable Player player, LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        return ItemStack.EMPTY;
    }

    default public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new SnowCoveredBlockEntity(pos, blockState);
    }
}

