/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;
import snownee.snow.mixin.IceBlockAccess;
import snownee.snow.util.CommonProxy;

public class WorldTickHandler {
    public static boolean tick(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).mutable();
        boolean coldEnoughToSnow = CommonProxy.coldEnoughToSnow((LevelReader)level, (BlockPos)mutable, (Holder<Biome>)level.getBiome((BlockPos)mutable));
        if (coldEnoughToSnow) {
            return WorldTickHandler.doSnow(level, mutable);
        }
        WorldTickHandler.doMelt(level, mutable);
        return false;
    }

    private static void doMelt(ServerLevel level, BlockPos.MutableBlockPos pos) {
        BlockState stateAbove;
        BlockState blockState = level.getBlockState((BlockPos)pos.move(Direction.DOWN));
        Block block = blockState.getBlock();
        if (block instanceof IceBlockAccess) {
            IceBlockAccess ice = (IceBlockAccess)block;
            Holder biome = level.getBiome((BlockPos)pos);
            if (CommonProxy.snowAndIceMeltInWarmBiomes((ResourceKey<Level>)level.dimension(), (Holder<Biome>)biome) && ((Biome)biome.value()).warmEnoughToRain((BlockPos)pos)) {
                ice.callMelt(blockState, (Level)level, (BlockPos)pos);
            }
            return;
        }
        if (blockState.getBlock() instanceof SnowVariant) {
            Hooks.randomTick(blockState, level, (BlockPos)pos, level.random, 1.0f);
        }
        if ((stateAbove = level.getBlockState((BlockPos)pos.move(Direction.UP))).getBlock() instanceof SnowVariant) {
            Hooks.randomTick(stateAbove, level, (BlockPos)pos, level.random, 1.0f);
        }
    }

    private static boolean doSnow(ServerLevel level, BlockPos.MutableBlockPos pos) {
        int blizzard;
        if (!level.isRaining()) {
            return false;
        }
        int n = blizzard = SnowCommonConfig.snowGravity ? level.getGameRules().getInt(CoreModule.BLIZZARD_STRENGTH) : 0;
        if (blizzard > 0) {
            WorldTickHandler.doBlizzard(level, (BlockPos)pos, blizzard);
            return true;
        }
        if (SnowCommonConfig.snowAccumulationMaxLayers <= 0) {
            return false;
        }
        BlockState blockState = level.getBlockState((BlockPos)pos);
        if (!WorldTickHandler.snowHereIfPossible(level, pos, blockState) && !WorldTickHandler.snowHereIfPossible(level, pos, blockState = level.getBlockState((BlockPos)pos.move(Direction.DOWN)))) {
            return false;
        }
        for (int i = 0; i < 5 && !blockState.is(BlockTags.SLABS) && !blockState.is(BlockTags.STAIRS) && ((blockState = level.getBlockState((BlockPos)pos.move(Direction.DOWN))).isAir() || Hooks.canContainState(blockState)); ++i) {
            if (!Hooks.canSnowSurvive((LevelReader)level, (BlockPos)pos)) continue;
            pos.move(Direction.UP);
            if (level.getBlockState((BlockPos)pos).getBlock() instanceof SnowLayerBlock || level.getBrightness(LightLayer.BLOCK, (BlockPos)pos) > SnowCommonConfig.snowSpawnMaxLightLevel) break;
            Hooks.convert((LevelAccessor)level, (BlockPos)pos.move(Direction.DOWN), blockState, 1, 3, SnowCommonConfig.placeSnowOnBlockNaturally);
        }
        return true;
    }

    private static boolean snowHereIfPossible(ServerLevel level, BlockPos.MutableBlockPos pos, BlockState blockState) {
        if (level.getBrightness(LightLayer.BLOCK, (BlockPos)pos.move(Direction.UP)) > SnowCommonConfig.snowSpawnMaxLightLevel) {
            pos.move(Direction.DOWN);
            return false;
        }
        return Hooks.convert((LevelAccessor)level, (BlockPos)pos.move(Direction.DOWN), blockState, 1, 3, SnowCommonConfig.placeSnowOnBlockNaturally);
    }

    private static void doBlizzard(ServerLevel world, BlockPos pos, int blizzard) {
        if (pos.getY() == world.getHeight()) {
            return;
        }
        int frequency = world.getGameRules().getInt(CoreModule.BLIZZARD_FREQUENCY);
        if ((frequency = Mth.clamp((int)frequency, (int)0, (int)10000)) == 0) {
            return;
        }
        int i = world.random.nextInt(10000);
        if (frequency != 10000 && i >= frequency) {
            return;
        }
        if ((blizzard = Mth.clamp((int)blizzard, (int)1, (int)8)) > 1) {
            blizzard = world.random.nextInt(blizzard) + 1;
        }
        pos = pos.above(64);
        FallingBlockEntity.fall((Level)world, (BlockPos)pos, (BlockState)((BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(blizzard))));
    }
}

