/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.scheduler;

import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ItemStatus;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ItemTicket;
import ca.spottedleaf.starlight.interndep.flowsched.scheduler.ObjectFactory;
import ca.spottedleaf.starlight.interndep.flowsched.util.Assertions;
import java.lang.invoke.VarHandle;
import java.util.Set;

public class TicketSet<K, V, Ctx> {
    private final ItemStatus<K, V, Ctx> initialStatus;
    private final Set<ItemTicket<K, V, Ctx>>[] status2Tickets;

    public TicketSet(ItemStatus<K, V, Ctx> initialStatus, ObjectFactory objectFactory) {
        this.initialStatus = initialStatus;
        ItemStatus<K, V, Ctx>[] allStatuses = initialStatus.getAllStatuses();
        this.status2Tickets = new Set[allStatuses.length];
        for (int i = 0; i < allStatuses.length; ++i) {
            this.status2Tickets[i] = objectFactory.createConcurrentSet();
        }
        VarHandle.fullFence();
    }

    public boolean add(ItemTicket<K, V, Ctx> ticket) {
        ItemStatus<K, V, Ctx> targetStatus = ticket.getTargetStatus();
        boolean added = this.status2Tickets[targetStatus.ordinal()].add(ticket);
        return added;
    }

    public boolean remove(ItemTicket<K, V, Ctx> ticket) {
        ItemStatus<K, V, Ctx> targetStatus = ticket.getTargetStatus();
        boolean removed = this.status2Tickets[targetStatus.ordinal()].remove(ticket);
        return removed;
    }

    public ItemStatus<K, V, Ctx> getTargetStatus() {
        return this.initialStatus.getAllStatuses()[this.computeTargetStatusSlow()];
    }

    public Set<ItemTicket<K, V, Ctx>> getTicketsForStatus(ItemStatus<K, V, Ctx> status) {
        return this.status2Tickets[status.ordinal()];
    }

    void clear() {
        for (Set<ItemTicket<K, V, Ctx>> tickets : this.status2Tickets) {
            tickets.clear();
        }
        VarHandle.fullFence();
    }

    void assertEmpty() {
        for (Set<ItemTicket<K, V, Ctx>> tickets : this.status2Tickets) {
            Assertions.assertTrue(tickets.isEmpty());
        }
    }

    private int computeTargetStatusSlow() {
        for (int i = this.status2Tickets.length - 1; i > 0; --i) {
            if (this.status2Tickets[i].isEmpty()) continue;
            return i;
        }
        return 0;
    }
}

