/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.util;

public interface Either<A, B> {
    public static <A, B> Either<A, B> left(A value) {
        return new Left(value);
    }

    public static <A, B> Either<A, B> right(B value) {
        return new Right(value);
    }

    public boolean isLeft();

    public boolean isRight();

    public A getLeft();

    public B getRight();

    public static class Left<A, B>
    implements Either<A, B> {
        private final A value;

        public Left(A value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public A getLeft() {
            return this.value;
        }

        @Override
        public B getRight() {
            throw new UnsupportedOperationException("No right value present");
        }
    }

    public static class Right<A, B>
    implements Either<A, B> {
        private final B value;

        public Right(B value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public A getLeft() {
            throw new UnsupportedOperationException("No left value present");
        }

        @Override
        public B getRight() {
            return this.value;
        }
    }
}

