/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.io.typed;

import com.bawnorton.configurable.io.typed.TypedReader;
import com.bawnorton.configurable.io.typed.TypedWriter;
import com.bawnorton.configurable.util.GenericType;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;

public final class TypedHandler<T> {
    private final TypedReader<T> reader;
    private final TypedWriter<T> writer;
    private GenericType expectedType;

    public TypedHandler(TypedReader<T> reader, TypedWriter<T> writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public void attachExpectedType(GenericType expectedType) {
        this.expectedType = expectedType;
    }

    public T readFromJson(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return this.reader.readJson(element, this.expectedType);
    }

    public T readFromToml(CommentedConfig config, String path) {
        if (config == null || !config.contains(path)) {
            return null;
        }
        return this.reader.readToml(config, path, this.expectedType);
    }

    public T readFromObject(Object item) {
        if (item == null) {
            return null;
        }
        return this.reader.readObject(item, this.expectedType);
    }

    public T readFromByteBuf(ByteBuf buf) {
        int nullCheck = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buf);
        if (nullCheck == -1) {
            return null;
        }
        if (nullCheck != 0) {
            throw new IllegalArgumentException("Expected a null check value of -1 or 0, but got: %d".formatted(nullCheck));
        }
        return this.reader.readByteBuf(buf, this.expectedType);
    }

    public void writeToByteBuf(ByteBuf buf, Object item) {
        if (item == null) {
            ByteBufCodecs.VAR_INT.encode((Object)buf, (Object)-1);
            return;
        }
        ByteBufCodecs.VAR_INT.encode((Object)buf, (Object)0);
        this.writer.writeByteBuf(buf, item, this.expectedType);
    }
}

