/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.common.worldgen.structure;

import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.core.VanillaBackport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.NetherFossilPieces;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetherFossilPieces.NetherFossilPiece.class})
public abstract class NetherFossilPieceMixin
extends TemplateStructurePiece {
    public NetherFossilPieceMixin(StructurePieceType type, int genDepth, StructureTemplateManager structureTemplateManager, ResourceLocation location, String templateName, StructurePlaceSettings placeSettings, BlockPos templatePosition) {
        super(type, genDepth, structureTemplateManager, location, templateName, placeSettings, templatePosition);
    }

    @Inject(method={"postProcess(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/util/RandomSource;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="TAIL")})
    private void placeDriedGhast(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource worldRandom, BoundingBox box, ChunkPos chunkPos, BlockPos origin, CallbackInfo ci) {
        if (((Boolean)VanillaBackport.CONFIG.generateDriedGhasts.get()).booleanValue() && level.dimensionType().ultraWarm() && level.dimensionType().piglinSafe()) {
            int z;
            int y;
            int x;
            BlockPos pos;
            BoundingBox template = this.template().getBoundingBox(this.placeSettings(), this.templatePosition());
            RandomSource random = RandomSource.create((long)level.getSeed()).forkPositional().at(template.getCenter());
            if (random.nextFloat() < 0.5f && level.getBlockState(pos = new BlockPos(x = template.minX() + random.nextInt(template.getXSpan()), y = template.minY(), z = template.minZ() + random.nextInt(template.getZSpan()))).isAir() && box.isInside((Vec3i)pos)) {
                level.setBlock(pos, ModBlocks.DRIED_GHAST.get().defaultBlockState().rotate(Rotation.getRandom((RandomSource)random)), 2);
            }
        }
    }
}

