/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.registries;

import com.blackgear.vanillabackport.common.registries.ModItems;
import com.blackgear.vanillabackport.core.VanillaBackport;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class ModTrimMaterials {
    public static final ResourceKey<TrimMaterial> RESIN = ModTrimMaterials.registryKey("resin");

    public static void bootstrap(BootstrapContext<TrimMaterial> context) {
        ModTrimMaterials.register(context, RESIN, ModItems.RESIN_BRICK.get(), Style.EMPTY.withColor(16545810), 0.5f);
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item ingredient, Style style, float itemModelIndex) {
        ModTrimMaterials.register(context, materialKey, ingredient, style, itemModelIndex, Map.of());
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item ingredient, Style style, float itemModelIndex, Map<Holder<ArmorMaterial>, String> overrideArmorMaterials) {
        TrimMaterial trimMaterial = TrimMaterial.create((String)materialKey.location().getPath(), (Item)ingredient, (float)itemModelIndex, (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)materialKey.location())).withStyle(style), overrideArmorMaterials);
        context.register(materialKey, (Object)trimMaterial);
    }

    private static ResourceKey<TrimMaterial> registryKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)VanillaBackport.resource(name));
    }
}

