/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.creaking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;

public class CreakingMeleeAttack {
    public static <T extends Mob> OneShot<T> create(Predicate<T> predicate, int cooldownBetweenAttacks) {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.registered(MemoryModuleType.LOOK_TARGET), (App)instance.present(MemoryModuleType.ATTACK_TARGET), (App)instance.absent(MemoryModuleType.ATTACK_COOLING_DOWN), (App)instance.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)instance, (lookTarget, attackTarget, attackCoolingDown, nearestVisibleLivingEntities) -> (serverLevel, mob, l) -> {
            LivingEntity target = (LivingEntity)instance.get(attackTarget);
            if (predicate.test(mob) && !CreakingMeleeAttack.isHoldingUsableProjectileWeapon(mob) && mob.isWithinMeleeAttackRange(target) && ((NearestVisibleLivingEntities)instance.get(nearestVisibleLivingEntities)).contains(target)) {
                lookTarget.set((Object)new EntityTracker((Entity)target, true));
                mob.swing(InteractionHand.MAIN_HAND);
                mob.doHurtTarget((Entity)target);
                attackCoolingDown.setWithExpiry((Object)true, (long)cooldownBetweenAttacks);
                return true;
            }
            return false;
        }));
    }

    private static boolean isHoldingUsableProjectileWeapon(Mob mob) {
        return mob.isHolding(stack -> {
            ProjectileWeaponItem projectile;
            Item item = stack.getItem();
            return item instanceof ProjectileWeaponItem && mob.canFireProjectileWeapon(projectile = (ProjectileWeaponItem)item);
        });
    }
}

