/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MossyCarpetBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<MossyCarpetBlock> CODEC = MossyCarpetBlock.simpleCodec(MossyCarpetBlock::new);
    public static final BooleanProperty BASE = BlockStateProperties.BOTTOM;
    private static final EnumProperty<WallSide> NORTH = BlockStateProperties.NORTH_WALL;
    private static final EnumProperty<WallSide> EAST = BlockStateProperties.EAST_WALL;
    private static final EnumProperty<WallSide> SOUTH = BlockStateProperties.SOUTH_WALL;
    private static final EnumProperty<WallSide> WEST = BlockStateProperties.WEST_WALL;
    private static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, NORTH);
        enumMap.put(Direction.EAST, EAST);
        enumMap.put(Direction.SOUTH, SOUTH);
        enumMap.put(Direction.WEST, WEST);
    })));
    private static final VoxelShape DOWN_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHORT_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0);
    private static final VoxelShape EAST_SHORT_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private static final VoxelShape NORTH_SHORT_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)1.0);
    private static final VoxelShape SOUTH_SHORT_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)10.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public MapCodec<MossyCarpetBlock> codec() {
        return CODEC;
    }

    public MossyCarpetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BASE, (Comparable)Boolean.valueOf(true))).setValue(NORTH, (Comparable)WallSide.NONE)).setValue(EAST, (Comparable)WallSide.NONE)).setValue(SOUTH, (Comparable)WallSide.NONE)).setValue(WEST, (Comparable)WallSide.NONE));
        this.shapesCache = ImmutableMap.copyOf(this.getStateDefinition().getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), MossyCarpetBlock::calculateShape)));
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape shape = Shapes.empty();
        if (((Boolean)state.getValue((Property)BASE)).booleanValue()) {
            shape = DOWN_AABB;
        }
        shape = switch ((WallSide)state.getValue(NORTH)) {
            default -> throw new MatchException(null, null);
            case WallSide.NONE -> shape;
            case WallSide.LOW -> Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_SHORT_AABB);
            case WallSide.TALL -> Shapes.or((VoxelShape)shape, (VoxelShape)NORTH_AABB);
        };
        shape = switch ((WallSide)state.getValue(SOUTH)) {
            default -> throw new MatchException(null, null);
            case WallSide.NONE -> shape;
            case WallSide.LOW -> Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_SHORT_AABB);
            case WallSide.TALL -> Shapes.or((VoxelShape)shape, (VoxelShape)SOUTH_AABB);
        };
        shape = switch ((WallSide)state.getValue(EAST)) {
            default -> throw new MatchException(null, null);
            case WallSide.NONE -> shape;
            case WallSide.LOW -> Shapes.or((VoxelShape)shape, (VoxelShape)EAST_SHORT_AABB);
            case WallSide.TALL -> Shapes.or((VoxelShape)shape, (VoxelShape)EAST_AABB);
        };
        shape = switch ((WallSide)state.getValue(WEST)) {
            default -> throw new MatchException(null, null);
            case WallSide.NONE -> shape;
            case WallSide.LOW -> Shapes.or((VoxelShape)shape, (VoxelShape)WEST_SHORT_AABB);
            case WallSide.TALL -> Shapes.or((VoxelShape)shape, (VoxelShape)WEST_AABB);
        };
        return shape.isEmpty() ? Shapes.block() : shape;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)BASE) != false ? DOWN_AABB : Shapes.empty();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState floorState = level.getBlockState(pos.below());
        return ((Boolean)state.getValue((Property)BASE)).booleanValue() ? !floorState.isAir() : floorState.is((Block)this) && (Boolean)floorState.getValue((Property)BASE) != false;
    }

    private static boolean hasFaces(BlockState state) {
        if (((Boolean)state.getValue((Property)BASE)).booleanValue()) {
            return true;
        }
        return PROPERTY_BY_DIRECTION.values().stream().anyMatch(property -> state.getValue((Property)property) != WallSide.NONE);
    }

    private static boolean canSupportAtFace(BlockGetter level, BlockPos pos, Direction direction) {
        BlockPos adjacent = pos.relative(direction);
        BlockState adjacentState = level.getBlockState(adjacent);
        return direction != Direction.UP && MultifaceBlock.canAttachTo((BlockGetter)level, (Direction)direction, (BlockPos)adjacent, (BlockState)adjacentState);
    }

    private static BlockState getUpdatedState(BlockState state, BlockGetter level, BlockPos pos, boolean flag) {
        BlockState aboveState = null;
        BlockState belowState = null;
        flag |= ((Boolean)state.getValue((Property)BASE)).booleanValue();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            WallSide wallSide;
            EnumProperty<WallSide> property = MossyCarpetBlock.getPropertyForFace(direction);
            WallSide wallSide2 = MossyCarpetBlock.canSupportAtFace(level, pos, direction) ? (flag ? WallSide.LOW : (WallSide)state.getValue(property)) : (wallSide = WallSide.NONE);
            if (wallSide == WallSide.LOW) {
                if (aboveState == null) {
                    aboveState = level.getBlockState(pos.above());
                }
                if (aboveState.is(ModBlocks.PALE_MOSS_CARPET.get()) && aboveState.getValue(property) != WallSide.NONE && !((Boolean)aboveState.getValue((Property)BASE)).booleanValue()) {
                    wallSide = WallSide.TALL;
                }
                if (!((Boolean)state.getValue((Property)BASE)).booleanValue()) {
                    if (belowState == null) {
                        belowState = level.getBlockState(pos.below());
                    }
                    if (belowState.is(ModBlocks.PALE_MOSS_CARPET.get()) && belowState.getValue(property) == WallSide.NONE) {
                        wallSide = WallSide.NONE;
                    }
                }
            }
            state = (BlockState)state.setValue(property, (Comparable)wallSide);
        }
        return state;
    }

    public static void placeAt(LevelAccessor level, BlockPos pos, RandomSource random, int flag) {
        BlockState base = ModBlocks.PALE_MOSS_CARPET.get().defaultBlockState();
        BlockState updatedState = MossyCarpetBlock.getUpdatedState(base, (BlockGetter)level, pos, true);
        level.setBlock(pos, updatedState, flag);
        BlockState topperState = MossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> ((RandomSource)random).nextBoolean());
        if (!topperState.isAir()) {
            level.setBlock(pos.above(), topperState, flag);
            BlockState reUpdatedState = MossyCarpetBlock.getUpdatedState(updatedState, (BlockGetter)level, pos, true);
            level.setBlock(pos, reUpdatedState, flag);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.isClientSide) {
            RandomSource random = level.getRandom();
            BlockState topperState = MossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> ((RandomSource)random).nextBoolean());
            if (!topperState.isAir()) {
                level.setBlock(pos.above(), topperState, 3);
            }
        }
    }

    private static BlockState createTopperWithSideChance(BlockGetter level, BlockPos pos, BooleanSupplier flag) {
        BlockPos above = pos.above();
        BlockState aboveState = level.getBlockState(above);
        boolean isCarpet = aboveState.is(ModBlocks.PALE_MOSS_CARPET.get());
        if (!(isCarpet && ((Boolean)aboveState.getValue((Property)BASE)).booleanValue() || !isCarpet && !aboveState.canBeReplaced())) {
            BlockState baselessCarpet = (BlockState)ModBlocks.PALE_MOSS_CARPET.get().defaultBlockState().setValue((Property)BASE, (Comparable)Boolean.valueOf(false));
            BlockState updatedState = MossyCarpetBlock.getUpdatedState(baselessCarpet, level, pos.above(), true);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                EnumProperty<WallSide> property = MossyCarpetBlock.getPropertyForFace(direction);
                if (updatedState.getValue(property) == WallSide.NONE || flag.getAsBoolean()) continue;
                updatedState = (BlockState)updatedState.setValue(property, (Comparable)WallSide.NONE);
            }
            return MossyCarpetBlock.hasFaces(updatedState) && updatedState != aboveState ? updatedState : Blocks.AIR.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return MossyCarpetBlock.getUpdatedState(this.defaultBlockState(), (BlockGetter)context.getLevel(), context.getClickedPos(), true);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState updatedState = MossyCarpetBlock.getUpdatedState(state, (BlockGetter)level, pos, false);
        return !MossyCarpetBlock.hasFaces(updatedState) ? Blocks.AIR.defaultBlockState() : updatedState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BASE, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((WallSide)state.getValue(SOUTH)))).setValue(EAST, (Comparable)((WallSide)state.getValue(WEST)))).setValue(SOUTH, (Comparable)((WallSide)state.getValue(NORTH)))).setValue(WEST, (Comparable)((WallSide)state.getValue(EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((WallSide)state.getValue(EAST)))).setValue(EAST, (Comparable)((WallSide)state.getValue(SOUTH)))).setValue(SOUTH, (Comparable)((WallSide)state.getValue(WEST)))).setValue(WEST, (Comparable)((WallSide)state.getValue(NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((WallSide)state.getValue(WEST)))).setValue(EAST, (Comparable)((WallSide)state.getValue(NORTH)))).setValue(SOUTH, (Comparable)((WallSide)state.getValue(EAST)))).setValue(WEST, (Comparable)((WallSide)state.getValue(SOUTH)));
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue(NORTH, (Comparable)((WallSide)state.getValue(SOUTH)))).setValue(SOUTH, (Comparable)((WallSide)state.getValue(NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue(EAST, (Comparable)((WallSide)state.getValue(WEST)))).setValue(WEST, (Comparable)((WallSide)state.getValue(EAST)));
            default -> super.mirror(state, mirror);
        };
    }

    @Nullable
    public static EnumProperty<WallSide> getPropertyForFace(Direction direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)BASE) != false && !MossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> true).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState topperState = MossyCarpetBlock.createTopperWithSideChance((BlockGetter)level, pos, () -> true);
        if (!topperState.isAir()) {
            level.setBlock(pos.above(), topperState, 3);
        }
    }
}

